/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.web;

import io.datarouter.auth.config.DatarouterAuthPaths;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.html.form.HtmlForm;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4FormHtml;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4PageFactory;
import io.datarouter.web.user.authenticate.config.DatarouterAuthenticationConfig;
import io.datarouter.web.user.authenticate.saml.DatarouterSamlSettings;
import io.datarouter.web.user.authenticate.saml.SamlService;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import javax.inject.Inject;

public class DatarouterSigninHandler
extends BaseHandler {
    @Inject
    private DatarouterAuthenticationConfig authenticationConfig;
    @Inject
    private DatarouterSamlSettings samlSettings;
    @Inject
    private SamlService samlService;
    @Inject
    private DatarouterAuthPaths paths;
    @Inject
    private Bootstrap4PageFactory pageFactory;

    @BaseHandler.Handler(defaultHandler=true)
    private Mav showForm() {
        if (this.samlSettings.getShouldProcess().booleanValue()) {
            this.samlService.redirectToIdentityProvider(this.request, this.response);
            return null;
        }
        HtmlForm form = new HtmlForm().withAction(String.valueOf(this.request.getContextPath()) + this.paths.signin.submit.toSlashedString()).withMethod("post");
        form.addEmailField().autofocus().withDisplay("Username").withName(this.authenticationConfig.getUsernameParam());
        form.addPasswordField().withDisplay("Password").withName(this.authenticationConfig.getPasswordParam());
        form.addButton().withDisplay("Submit").withValue("anything");
        return this.pageFactory.startBuilder(this.request).withTitle("Sign in").includeNav(false).withContent(Html.makeContent(form)).buildMav();
    }

    private static class Html {
        private Html() {
        }

        public static ContainerTag makeContent(HtmlForm htmlForm) {
            ContainerTag form = (ContainerTag)Bootstrap4FormHtml.render((HtmlForm)htmlForm).withClass("card card-body bg-light");
            return (ContainerTag)TagCreator.div((DomContent[])new DomContent[]{TagCreator.h2((String)"Sign in"), form, TagCreator.br()}).withClass("container mt-3");
        }
    }
}

