/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.service;

import io.datarouter.auth.service.DatarouterUserHistoryService;
import io.datarouter.auth.service.DatarouterUserService;
import io.datarouter.httpclient.client.DatarouterService;
import io.datarouter.storage.config.DatarouterProperties;
import io.datarouter.util.number.RandomTool;
import io.datarouter.web.user.authenticate.DatarouterTokenGenerator;
import io.datarouter.web.user.databean.DatarouterUser;
import io.datarouter.web.user.databean.DatarouterUserKey;
import io.datarouter.web.user.role.DatarouterUserRole;
import io.datarouter.web.user.session.service.Role;
import io.datarouter.web.util.PasswordTool;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DatarouterUserCreationService {
    private static final Logger logger = LoggerFactory.getLogger(DatarouterUserCreationService.class);
    public static final long ADMIN_ID = 1L;
    private static final Set<Role> DEFAULT_ADMIN_ROLES = Stream.of(DatarouterUserRole.DATAROUTER_ADMIN, DatarouterUserRole.ADMIN, DatarouterUserRole.USER, DatarouterUserRole.API_USER, DatarouterUserRole.REQUESTOR).map(DatarouterUserRole::getRole).collect(Collectors.toSet());
    @Inject
    private DatarouterProperties datarouterProperties;
    @Inject
    private DatarouterUserService datarouterUserService;
    @Inject
    private DatarouterUserHistoryService userHistoryService;
    @Inject
    private DatarouterService datarouterService;

    public void createFirstAdminUser(String defaultPassword) {
        DatarouterUser user = new DatarouterUser();
        this.populateGeneratedFields(user, CreateType.ADMIN, defaultPassword, Optional.empty());
        this.populateManualFields(user, this.datarouterProperties.getAdministratorEmail(), DEFAULT_ADMIN_ROLES, true);
        this.finishCreate(user, 1L, "Automatically created admin user.");
        logger.warn("Created default admin user account");
    }

    public DatarouterUser createAutomaticUserWithoutPersist(String username, String description, Set<Role> roles) {
        return this.createAutomaticUser(username, description, roles, false);
    }

    public DatarouterUser createAutomaticUser(String username, String description) {
        return this.createAutomaticUser(username, description, Set.of(DatarouterUserRole.REQUESTOR.getRole()));
    }

    public DatarouterUser createAutomaticUser(String username, String description, Set<Role> roles) {
        return this.createAutomaticUser(username, description, roles, true);
    }

    private DatarouterUser createAutomaticUser(String username, String description, Set<Role> roles, boolean shouldPersist) {
        roles.add(DatarouterUserRole.REQUESTOR.getRole());
        DatarouterUser user = new DatarouterUser();
        this.populateGeneratedFields(user, CreateType.AUTO, null, Optional.empty());
        this.populateManualFields(user, username, roles, true);
        if (shouldPersist) {
            return this.finishCreate(user, 1L, description);
        }
        return user;
    }

    public DatarouterUser createManualUser(DatarouterUser creator, String username, String password, Set<Role> requestedRoles, boolean enabled, Optional<ZoneId> zoneId, Optional<String> description) {
        DatarouterUser user = new DatarouterUser();
        this.populateGeneratedFields(user, CreateType.MANUAL, password, zoneId);
        this.populateManualFields(user, username, this.datarouterUserService.getAllowedUserRoles(creator, requestedRoles), enabled);
        String roles = user.getRoles().isEmpty() ? "" : ": roles: " + List.of() + " => " + user.getRoles();
        String historyDescription = String.valueOf(description.orElse("User manually created by " + creator.getUsername())) + roles;
        return this.finishCreate(user, creator.getId(), historyDescription);
    }

    private void populateGeneratedFields(DatarouterUser user, CreateType type, String password, Optional<ZoneId> zoneId) {
        ((DatarouterUserKey)user.getKey()).setId(Long.valueOf(type == CreateType.ADMIN ? 1L : RandomTool.nextPositiveLong()));
        user.setUserToken(DatarouterTokenGenerator.generateRandomToken());
        user.setCreated(new Date());
        user.setLastLoggedIn(type == CreateType.ADMIN ? user.getCreatedInstant() : null);
        user.setPasswordSalt(type == CreateType.AUTO ? null : PasswordTool.generateSalt());
        user.setPasswordDigest(type == CreateType.AUTO || password == null ? null : PasswordTool.digest((String)user.getPasswordSalt(), (String)password));
        if (zoneId.isPresent()) {
            user.setZoneId(this.datarouterService.getZoneId());
        }
    }

    private void populateManualFields(DatarouterUser user, String username, Set<Role> roles, Boolean enabled) {
        user.setUsername(username);
        user.setRoles(roles);
        user.setEnabled(enabled);
    }

    private DatarouterUser finishCreate(DatarouterUser user, Long editorId, String description) {
        this.datarouterUserService.assertUserDoesNotExist(user.getId(), user.getUserToken(), user.getUsername());
        this.userHistoryService.putAndRecordCreate(user, editorId, description);
        return user;
    }

    private static enum CreateType {
        ADMIN,
        AUTO,
        MANUAL;

    }
}

