/*
 * Copyright © 2009 HotPads (admin@hotpads.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.datarouter.auth.storage.useraccountmap;

import java.util.List;
import java.util.function.Supplier;

import io.datarouter.model.databean.BaseDatabean;
import io.datarouter.model.field.Field;
import io.datarouter.model.serialize.fielder.BaseDatabeanFielder;

public class DatarouterUserAccountMap extends BaseDatabean<DatarouterUserAccountMapKey,DatarouterUserAccountMap>{

	public DatarouterUserAccountMap(){
		super(new DatarouterUserAccountMapKey());
	}

	public DatarouterUserAccountMap(Long userId, String accountName){
		super(new DatarouterUserAccountMapKey(userId, accountName));
	}

	public static class DatarouterUserAccountMapFielder
	extends BaseDatabeanFielder<DatarouterUserAccountMapKey,DatarouterUserAccountMap>{

		public DatarouterUserAccountMapFielder(){
			super(DatarouterUserAccountMapKey::new);
		}

		@Override
		public List<Field<?>> getNonKeyFields(DatarouterUserAccountMap databean){
			return List.of();
		}

	}

	@Override
	public Supplier<DatarouterUserAccountMapKey> getKeySupplier(){
		return DatarouterUserAccountMapKey::new;
	}

}
