/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.service;

import io.datarouter.auth.config.DatarouterAuthExecutors;
import io.datarouter.auth.storage.account.DatarouterAccount;
import io.datarouter.auth.storage.account.DatarouterAccountKey;
import io.datarouter.auth.storage.useraccountmap.DatarouterUserAccountMapDao;
import io.datarouter.instrumentation.changelog.ChangelogRecorder;
import io.datarouter.storage.config.DatarouterProperties;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DatarouterAccountDeleteAction {
    @Inject
    private DatarouterUserAccountMapDao userAccountMapDao;
    @Inject
    private ChangelogRecorder changelogRecorder;
    @Inject
    private DatarouterProperties datarouterProperties;
    @Inject
    private DatarouterAuthExecutors.DatarouterAccountDeleteActionExecutor executor;

    public final void onDelete(DatarouterAccount account) {
        this.executor.submit(() -> {
            this.additionalOnDeleteActions(account);
            this.cleanupDatarouterUserAccounts(account);
        });
    }

    private void cleanupDatarouterUserAccounts(DatarouterAccount account) {
        if (!account.getEnableUserMappings()) {
            return;
        }
        this.userAccountMapDao.scanKeys().include(key -> key.getAccountName().equals(((DatarouterAccountKey)account.getKey()).getAccountName())).flush(this.userAccountMapDao::deleteMulti);
        this.recordChangelog(account, "cleanup datarouter users");
    }

    protected void additionalOnDeleteActions(DatarouterAccount account) {
    }

    protected final void recordChangelog(DatarouterAccount account, String action) {
        ChangelogRecorder.DatarouterChangelogDtoBuilder changelogBuilder = new ChangelogRecorder.DatarouterChangelogDtoBuilder("DatarouterAccount", ((DatarouterAccountKey)account.getKey()).getAccountName(), action, this.datarouterProperties.getAdministratorEmail());
        this.changelogRecorder.record(changelogBuilder.build());
    }
}

