/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.service;

import io.datarouter.auth.cache.DatarouterAccountPermissionKeysByPrefixCache;
import io.datarouter.auth.config.DatarouterAuthExecutors;
import io.datarouter.auth.service.DatarouterAccountLastUsedDateService;
import io.datarouter.auth.storage.account.BaseDatarouterAccountCredentialDao;
import io.datarouter.auth.storage.account.BaseDatarouterAccountSecretCredentialDao;
import io.datarouter.auth.storage.account.DatarouterAccountCredential;
import io.datarouter.auth.storage.account.DatarouterAccountCredentialKey;
import io.datarouter.auth.storage.account.DatarouterAccountSecretCredential;
import io.datarouter.auth.storage.account.DatarouterAccountSecretCredentialKey;
import io.datarouter.auth.storage.accountpermission.DatarouterAccountPermissionKey;
import io.datarouter.auth.web.DatarouterAccountManagerHandler;
import io.datarouter.scanner.Scanner;
import io.datarouter.secret.op.SecretOpReason;
import io.datarouter.secret.service.SecretNamespacer;
import io.datarouter.secret.service.SecretService;
import io.datarouter.secretweb.service.WebSecretOpReason;
import io.datarouter.util.Require;
import io.datarouter.web.user.session.service.Session;
import io.datarouter.web.util.PasswordTool;
import io.datarouter.web.util.http.RequestTool;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;

@Singleton
public class DatarouterAccountCredentialService {
    private static final String SECRET_NAMESPACE_SUFFIX = "drSecretCredentials/";
    private final BaseDatarouterAccountCredentialDao datarouterAccountCredentialDao;
    private final BaseDatarouterAccountSecretCredentialDao datarouterAccountSecretCredentialDao;
    private final DatarouterAccountPermissionKeysByPrefixCache datarouterAccountPermissionKeysByPrefixCache;
    private final DatarouterAccountLastUsedDateService datarouterAccountLastUsedDateService;
    private final SecretService secretService;
    private final SecretNamespacer secretNamespacer;
    private final AtomicReference<Map<String, AccountKey>> credentialAccountKeyByApiKey;
    private final AtomicReference<Map<String, String>> secretCredentialApiKeyBySecretName;
    private final AtomicReference<Map<String, AccountKey>> secretCredentialAccountKeyByApiKey;

    @Inject
    public DatarouterAccountCredentialService(BaseDatarouterAccountCredentialDao datarouterAccountCredentialDao, BaseDatarouterAccountSecretCredentialDao datarouterAccountSecretCredentialDao, DatarouterAccountPermissionKeysByPrefixCache datarouterAccountPermissionKeysByPrefixCache, DatarouterAccountLastUsedDateService datarouterAccountLastUsedDateService, DatarouterAuthExecutors.DatarouterAccountCredentialCacheExecutor executor, SecretService secretService, SecretNamespacer secretNamespacer) {
        this.datarouterAccountCredentialDao = datarouterAccountCredentialDao;
        this.datarouterAccountSecretCredentialDao = datarouterAccountSecretCredentialDao;
        this.datarouterAccountPermissionKeysByPrefixCache = datarouterAccountPermissionKeysByPrefixCache;
        this.datarouterAccountLastUsedDateService = datarouterAccountLastUsedDateService;
        this.secretService = secretService;
        this.secretNamespacer = secretNamespacer;
        this.credentialAccountKeyByApiKey = new AtomicReference(new HashMap());
        this.secretCredentialApiKeyBySecretName = new AtomicReference(new HashMap());
        this.secretCredentialAccountKeyByApiKey = new AtomicReference(new HashMap());
        this.refreshCaches();
        executor.scheduleWithFixedDelay(this::refreshCaches, 30L, 30L, TimeUnit.SECONDS);
    }

    public Scanner<DatarouterAccountPermissionKey> scanPermissionsForApiKeyAuth(String apiKey) {
        return this.findAccountKeyApiKeyAuth(apiKey, true).map(accountKey -> accountKey.accountName).map(DatarouterAccountPermissionKey::new).map(this.datarouterAccountPermissionKeysByPrefixCache::get).map(Scanner::of).orElseGet(Scanner::empty);
    }

    public Optional<String> findSecretKeyForApiKeyAuth(String apiKey) {
        return this.findAccountKeyApiKeyAuth(apiKey, true).map(accountKey -> accountKey.secretKey);
    }

    public Optional<String> getCurrentDatarouterAccountName(HttpServletRequest request) {
        String apiKey = RequestTool.getParameterOrHeader((HttpServletRequest)request, (String)"apiKey");
        return this.findAccountKeyApiKeyAuth(apiKey, false).map(accountKey -> accountKey.accountName);
    }

    public String getAccountNameForRequest(HttpServletRequest request) {
        return this.getCurrentDatarouterAccountName(request).orElseThrow();
    }

    public void deleteAllCredentialsForAccount(String accountName, Session session) {
        this.datarouterAccountCredentialDao.deleteByAccountName(accountName);
        SecretOpReason reason = WebSecretOpReason.manualOp((Session)session, (String)("deleteAllCredentialsForAccount " + accountName));
        this.datarouterAccountSecretCredentialDao.scan().include(secretCredential -> accountName.equals(secretCredential.getAccountName())).each(secretCredential -> {
            this.secretService.deleteNamespaced(Optional.empty(), secretCredential.getSecretNamespace(), ((DatarouterAccountSecretCredentialKey)secretCredential.getKey()).getSecretName(), reason);
            this.datarouterAccountSecretCredentialDao.delete((DatarouterAccountSecretCredentialKey)secretCredential.getKey());
        });
    }

    public void createCredential(String accountName, String creatorUsername) {
        DatarouterAccountCredential credential;
        while (this.findAccountKeyApiKeyAuth(((DatarouterAccountCredentialKey)(credential = DatarouterAccountCredential.create(accountName, creatorUsername)).getKey()).getApiKey(), false).isPresent()) {
        }
        this.datarouterAccountCredentialDao.insertOrBust(credential);
    }

    public void deleteCredential(String apiKey) {
        this.datarouterAccountCredentialDao.delete(new DatarouterAccountCredentialKey(apiKey));
    }

    public void setCredentialActivation(String apiKey, Boolean active) {
        DatarouterAccountCredentialKey key = new DatarouterAccountCredentialKey(apiKey);
        DatarouterAccountCredential databean = this.datarouterAccountCredentialDao.get(key);
        databean.setActive(active);
        this.datarouterAccountCredentialDao.updateIgnore(databean);
    }

    public DatarouterAccountSecretCredentialKeypairDto createSecretCredential(String accountName, String creatorUsername, SecretOpReason reason) {
        DatarouterAccountSecretCredentialKeypairDto keypair;
        String secretNamespace = String.valueOf(this.secretNamespacer.getAppNamespace()) + SECRET_NAMESPACE_SUFFIX;
        DatarouterAccountSecretCredential credential = DatarouterAccountSecretCredential.create(secretNamespace, accountName, creatorUsername);
        this.datarouterAccountSecretCredentialDao.insertOrBust(credential);
        do {
            keypair = DatarouterAccountSecretCredentialKeypairDto.create();
        } while (this.findAccountKeyApiKeyAuth(keypair.apiKey, false).isPresent());
        try {
            this.secretService.createNamespaced(secretNamespace, ((DatarouterAccountSecretCredentialKey)credential.getKey()).getSecretName(), (Object)keypair, reason);
        }
        catch (RuntimeException e) {
            this.datarouterAccountSecretCredentialDao.delete((DatarouterAccountSecretCredentialKey)credential.getKey());
            throw e;
        }
        return keypair;
    }

    public boolean deleteSecretCredential(String secretName, SecretOpReason reason) {
        DatarouterAccountSecretCredentialKey key = new DatarouterAccountSecretCredentialKey(secretName);
        DatarouterAccountSecretCredential databean = this.datarouterAccountSecretCredentialDao.get(key);
        if (databean == null) {
            return false;
        }
        this.secretService.deleteNamespaced(Optional.empty(), databean.getSecretNamespace(), secretName, reason);
        this.datarouterAccountSecretCredentialDao.delete(key);
        return true;
    }

    public void setSecretCredentialActivation(String secretName, Boolean active) {
        DatarouterAccountSecretCredentialKey key = new DatarouterAccountSecretCredentialKey(secretName);
        DatarouterAccountSecretCredential databean = this.datarouterAccountSecretCredentialDao.get(key);
        databean.setActive(active);
        this.datarouterAccountSecretCredentialDao.updateIgnore(databean);
    }

    public Map<String, List<DatarouterAccountManagerHandler.AccountCredentialDto>> getCredentialsByAccountName(Set<String> accountNames, ZoneId zoneId) {
        return this.datarouterAccountCredentialDao.scanByAccountName(accountNames).map(credential -> new DatarouterAccountManagerHandler.AccountCredentialDto((DatarouterAccountCredential)((Object)credential), zoneId)).groupBy(credential -> credential.accountName);
    }

    public Map<String, List<SecretCredentialDto>> getSecretCredentialsByAccountName(Set<String> accountNames, ZoneId zoneId) {
        return this.datarouterAccountSecretCredentialDao.scan().include(secretCredential -> accountNames.contains(secretCredential.getAccountName())).map(databean -> new SecretCredentialDto((DatarouterAccountSecretCredential)((Object)databean), zoneId)).groupBy(dto -> dto.accountName);
    }

    private Optional<AccountKey> findAccountKeyApiKeyAuth(String apiKey, boolean shouldUpdate) {
        AccountKey accountKey = this.secretCredentialAccountKeyByApiKey.get().get(apiKey);
        if (accountKey != null) {
            if (shouldUpdate) {
                this.datarouterAccountLastUsedDateService.updateLastUsedDateForSecretCredential(accountKey.getDatarouterAccountSecretCredentialKey(), accountKey.accountName);
            }
            return Optional.of(accountKey);
        }
        accountKey = this.credentialAccountKeyByApiKey.get().get(apiKey);
        if (accountKey != null) {
            if (shouldUpdate) {
                this.datarouterAccountLastUsedDateService.updateLastUsedDateForCredential(accountKey.getDatarouterAccountCredentialKey(), accountKey.accountName);
            }
            return Optional.of(accountKey);
        }
        return Optional.empty();
    }

    private void refreshCredentials() {
        this.credentialAccountKeyByApiKey.set(this.datarouterAccountCredentialDao.scan().include(DatarouterAccountCredential::getActive).toMap(databean -> ((DatarouterAccountCredentialKey)databean.getKey()).getApiKey(), datarouterAccountCredential -> new AccountKey((DatarouterAccountCredential)((Object)datarouterAccountCredential))));
    }

    private void refreshSecretCredentials() {
        Map<String, String> oldApiKeyBySecretName = this.secretCredentialApiKeyBySecretName.get();
        Map<String, AccountKey> oldAccountKeyByApiKey = this.secretCredentialAccountKeyByApiKey.get();
        HashMap newApiKeyBySecretName = new HashMap();
        HashMap newAccountKeyByApiKey = new HashMap();
        this.datarouterAccountSecretCredentialDao.scan().include(DatarouterAccountSecretCredential::getActive).forEach(credential -> {
            String secretName = ((DatarouterAccountSecretCredentialKey)credential.getKey()).getSecretName();
            String oldApiKey = (String)oldApiKeyBySecretName.get(secretName);
            AccountKey oldAccountKey = (AccountKey)oldAccountKeyByApiKey.get(oldApiKey);
            if (oldApiKey != null && oldAccountKey != null) {
                newApiKeyBySecretName.put(secretName, oldApiKey);
                newAccountKeyByApiKey.put(oldApiKey, oldAccountKey);
            } else {
                SecretOpReason reason = SecretOpReason.automatedOp((String)(String.valueOf(DatarouterAccountCredentialService.class.getSimpleName()) + " caching"));
                DatarouterAccountSecretCredentialKeypairDto keypair = this.readKeypair((DatarouterAccountSecretCredential)((Object)credential), reason);
                newApiKeyBySecretName.put(secretName, keypair.apiKey);
                newAccountKeyByApiKey.put(keypair.apiKey, new AccountKey(keypair, (DatarouterAccountSecretCredential)((Object)credential)));
            }
        });
        this.secretCredentialApiKeyBySecretName.set(newApiKeyBySecretName);
        this.secretCredentialAccountKeyByApiKey.set(newAccountKeyByApiKey);
    }

    private DatarouterAccountSecretCredentialKeypairDto readKeypair(DatarouterAccountSecretCredential secretCredential, SecretOpReason reason) {
        return (DatarouterAccountSecretCredentialKeypairDto)this.secretService.readNamespaced(secretCredential.getSecretNamespace(), ((DatarouterAccountSecretCredentialKey)secretCredential.getKey()).getSecretName(), DatarouterAccountSecretCredentialKeypairDto.class, reason);
    }

    private void refreshCaches() {
        this.refreshCredentials();
        this.refreshSecretCredentials();
    }

    private static class AccountKey {
        private final String apiKey;
        private final String secretKey;
        private final String accountName;
        private final String secretName;

        private AccountKey(DatarouterAccountCredential credential) {
            this.apiKey = (String)Require.notNull((Object)((DatarouterAccountCredentialKey)credential.getKey()).getApiKey());
            this.secretKey = (String)Require.notNull((Object)credential.getSecretKey());
            this.accountName = (String)Require.notNull((Object)credential.getAccountName());
            this.secretName = null;
        }

        private AccountKey(DatarouterAccountSecretCredentialKeypairDto keypair, DatarouterAccountSecretCredential credential) {
            this.apiKey = (String)Require.notNull((Object)keypair.apiKey);
            this.secretKey = (String)Require.notNull((Object)keypair.secretKey);
            this.accountName = (String)Require.notNull((Object)credential.getAccountName());
            this.secretName = (String)Require.notNull((Object)((DatarouterAccountSecretCredentialKey)credential.getKey()).getSecretName());
        }

        DatarouterAccountCredentialKey getDatarouterAccountCredentialKey() {
            return new DatarouterAccountCredentialKey(this.apiKey);
        }

        DatarouterAccountSecretCredentialKey getDatarouterAccountSecretCredentialKey() {
            return new DatarouterAccountSecretCredentialKey(this.secretName);
        }
    }

    public static class DatarouterAccountSecretCredentialKeypairDto {
        public final String apiKey;
        public final String secretKey;

        public DatarouterAccountSecretCredentialKeypairDto(String apiKey, String secretKey) {
            this.apiKey = apiKey;
            this.secretKey = secretKey;
        }

        public static DatarouterAccountSecretCredentialKeypairDto create() {
            return new DatarouterAccountSecretCredentialKeypairDto(PasswordTool.generateSalt(), PasswordTool.generateSalt());
        }
    }

    public static class SecretCredentialDto {
        public final String secretName;
        public final String accountName;
        public final String created;
        public final String creatorUsername;
        public final String lastUsed;
        public final Boolean active;

        public SecretCredentialDto(DatarouterAccountSecretCredential credential, ZoneId zoneId) {
            this.secretName = ((DatarouterAccountSecretCredentialKey)credential.getKey()).getSecretName();
            this.accountName = credential.getAccountName();
            this.created = credential.getCreatedDate(zoneId);
            this.creatorUsername = credential.getCreatorUsername();
            this.lastUsed = credential.getLastUsedDate(zoneId);
            this.active = credential.getActive();
        }
    }
}

