/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.service;

import io.datarouter.auth.cache.DatarouterUserByUsernameCache;
import io.datarouter.auth.config.DatarouterAuthPaths;
import io.datarouter.auth.service.DatarouterUserService;
import io.datarouter.auth.storage.user.DatarouterUserDao;
import io.datarouter.util.BooleanTool;
import io.datarouter.util.lang.ObjectTool;
import io.datarouter.util.string.StringTool;
import io.datarouter.web.exception.IncorrectPasswordException;
import io.datarouter.web.exception.InvalidCredentialsException;
import io.datarouter.web.user.authenticate.authenticator.DatarouterAuthenticator;
import io.datarouter.web.user.authenticate.config.DatarouterAuthenticationConfig;
import io.datarouter.web.user.authenticate.saml.DatarouterSamlSettings;
import io.datarouter.web.user.databean.DatarouterUser;
import io.datarouter.web.user.session.DatarouterSession;
import io.datarouter.web.util.http.RequestTool;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DatarouterSigninFormAuthenticator
implements DatarouterAuthenticator {
    private static final Logger logger = LoggerFactory.getLogger(DatarouterSigninFormAuthenticator.class);
    @Inject
    private DatarouterAuthenticationConfig authenticationConfig;
    @Inject
    private DatarouterUserDao datarouterUserDao;
    @Inject
    private DatarouterSamlSettings samlSettings;
    @Inject
    private DatarouterUserByUsernameCache datarouterUserByUsernameCache;
    @Inject
    private DatarouterUserService datarouterUserService;
    @Inject
    private DatarouterAuthPaths paths;

    public DatarouterSession getSession(HttpServletRequest request, HttpServletResponse response) {
        if (ObjectTool.notEquals((Object)request.getServletPath(), (Object)this.paths.signin.submit.toSlashedString())) {
            return null;
        }
        String username = RequestTool.get((HttpServletRequest)request, (String)this.authenticationConfig.getUsernameParam(), null);
        String password = RequestTool.get((HttpServletRequest)request, (String)this.authenticationConfig.getPasswordParam(), null);
        if (ObjectTool.anyNull((Object[])new Object[]{username, password})) {
            return null;
        }
        if (this.samlSettings.getShouldProcess().booleanValue()) {
            logger.info("Sign in form disabled.");
            return null;
        }
        DatarouterUser user = this.lookupAndValidateUser(username, password);
        user.setLastLoggedIn(new Date());
        this.datarouterUserDao.put(user);
        DatarouterSession session = DatarouterSession.createFromUser((DatarouterUser)user);
        return session;
    }

    private DatarouterUser lookupAndValidateUser(String username, String password) {
        if (StringTool.isEmpty((String)username)) {
            throw new InvalidCredentialsException("no username specified");
        }
        DatarouterUser user = (DatarouterUser)this.datarouterUserByUsernameCache.getOrThrow(username);
        if (BooleanTool.isFalseOrNull((Boolean)user.getEnabled())) {
            throw new InvalidCredentialsException("user not enabled (" + username + ")");
        }
        if (StringTool.isEmpty((String)password)) {
            throw new InvalidCredentialsException("password cannot be empty (" + username + ")");
        }
        if (!this.datarouterUserService.isPasswordCorrect(user, password)) {
            throw new IncorrectPasswordException("invalid password (" + username + ")");
        }
        return user;
    }
}

