/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.service;

import io.datarouter.auth.cache.DatarouterAccountPermissionKeysByPrefixCache;
import io.datarouter.auth.service.DatarouterAccountLastUsedDateService;
import io.datarouter.auth.storage.account.BaseDatarouterAccountCredentialDao;
import io.datarouter.auth.storage.account.BaseDatarouterAccountDao;
import io.datarouter.auth.storage.account.DatarouterAccount;
import io.datarouter.auth.storage.account.DatarouterAccountCredential;
import io.datarouter.auth.storage.account.DatarouterAccountKey;
import io.datarouter.auth.storage.accountpermission.DatarouterAccountPermissionKey;
import io.datarouter.auth.storage.useraccountmap.BaseDatarouterUserAccountMapDao;
import io.datarouter.auth.storage.useraccountmap.DatarouterUserAccountMapKey;
import io.datarouter.model.databean.BaseDatabean;
import io.datarouter.scanner.Scanner;
import io.datarouter.web.user.session.service.Session;
import io.datarouter.web.user.session.service.SessionBasedUser;
import io.datarouter.web.util.http.RequestTool;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;

@Singleton
public class DatarouterAccountService {
    private final BaseDatarouterAccountDao datarouterAccountDao;
    private final BaseDatarouterAccountCredentialDao datarouterAccountCredentialDao;
    private final BaseDatarouterUserAccountMapDao datarouterUserAccountMapDao;
    private final DatarouterAccountPermissionKeysByPrefixCache datarouterAccountPermissionKeysByPrefixCache;
    private final DatarouterAccountLastUsedDateService datarouterAccountLastUsedDateService;

    @Inject
    public DatarouterAccountService(BaseDatarouterAccountDao datarouterAccountDao, BaseDatarouterAccountCredentialDao datarouterAccountCredentialDao, BaseDatarouterUserAccountMapDao datarouterUserAccountMapDao, DatarouterAccountPermissionKeysByPrefixCache datarouterAccountPermissionKeysByPrefixCache, DatarouterAccountLastUsedDateService datarouterAccountLastUsedDateService) {
        this.datarouterAccountDao = datarouterAccountDao;
        this.datarouterAccountCredentialDao = datarouterAccountCredentialDao;
        this.datarouterUserAccountMapDao = datarouterUserAccountMapDao;
        this.datarouterAccountPermissionKeysByPrefixCache = datarouterAccountPermissionKeysByPrefixCache;
        this.datarouterAccountLastUsedDateService = datarouterAccountLastUsedDateService;
    }

    public List<String> getAllAccountNamesWithUserMappingsEnabled() {
        return this.datarouterAccountDao.scan().include(DatarouterAccount::getEnableUserMappings).map(BaseDatabean::getKey).map(DatarouterAccountKey::getAccountName).list();
    }

    public Scanner<DatarouterAccountPermissionKey> scanPermissionsForApiKeyAuth(String apiKey) {
        return this.findAccountCredentialForApiKeyAuth(apiKey).map(DatarouterAccountCredential::getAccountName).map(DatarouterAccountPermissionKey::new).map(this.datarouterAccountPermissionKeysByPrefixCache::get).map(Scanner::of).orElseGet(Scanner::empty);
    }

    public Optional<DatarouterAccountCredential> findAccountCredentialForApiKeyAuth(String apiKey) {
        Optional<DatarouterAccountCredential> accountCredential = this.datarouterAccountCredentialDao.getFromAccountCredentialByApiKeyCache(apiKey);
        accountCredential.ifPresent(this.datarouterAccountLastUsedDateService::updateLastUsedDate);
        return accountCredential;
    }

    public Optional<String> getCurrentDatarouterAccountName(HttpServletRequest request) {
        String apiKey = RequestTool.getParameterOrHeader((HttpServletRequest)request, (String)"apiKey");
        return Optional.ofNullable(apiKey).flatMap(this.datarouterAccountCredentialDao::getFromAccountCredentialByApiKeyCache).map(DatarouterAccountCredential::getAccountName);
    }

    public String getAccountNameForRequest(HttpServletRequest request) {
        return this.getCurrentDatarouterAccountName(request).orElseThrow();
    }

    public boolean userCanAccessAccount(Session session, String accountName) {
        if (!this.userCanAccessAccount(session.getUserId(), accountName)) {
            return false;
        }
        return this.datarouterAccountDao.find(new DatarouterAccountKey(accountName)).map(DatarouterAccount::getEnableUserMappings).orElse(false);
    }

    private boolean userCanAccessAccount(Long userId, String accountName) {
        if (userId == null) {
            return false;
        }
        DatarouterUserAccountMapKey key = new DatarouterUserAccountMapKey(userId, accountName);
        return this.datarouterUserAccountMapDao.exists(key);
    }

    public Set<String> findAccountNamesForUser(SessionBasedUser user) {
        return (Set)this.scanAccountNamesForUserIdWithUserMappingEnabled(user.getId()).collect(HashSet::new);
    }

    public Set<String> findAccountNamesForUser(Session session) {
        return (Set)this.scanAccountNamesForUserIdWithUserMappingEnabled(session.getUserId()).collect(HashSet::new);
    }

    public Optional<DatarouterAccountCredential> findFirstAccountCredentialForUser(Session session) {
        if (session.getUserId() == null) {
            return Optional.empty();
        }
        return this.scanAccountNamesForUserIdWithUserMappingEnabled(session.getUserId()).map(this.datarouterAccountCredentialDao::getFromAccountCredentialByAccountNameCache).include(Optional::isPresent).map(Optional::get).findFirst();
    }

    public Scanner<DatarouterAccount> scanAccountsForUser(Session session) {
        return this.scanAccountsForUserIdWithUserMappingEnabled(session.getUserId());
    }

    private Scanner<String> scanAccountNamesForUserIdWithUserMappingEnabled(Long userId) {
        if (userId == null) {
            return Scanner.empty();
        }
        return this.scanAccountsForUserIdWithUserMappingEnabled(userId).map(BaseDatabean::getKey).map(DatarouterAccountKey::getAccountName);
    }

    private Scanner<DatarouterAccount> scanAccountsForUserIdWithUserMappingEnabled(Long userId) {
        if (userId == null) {
            return Scanner.empty();
        }
        DatarouterUserAccountMapKey prefix = new DatarouterUserAccountMapKey(userId, null);
        return ((Scanner)this.datarouterUserAccountMapDao.scanKeysWithPrefix(prefix).map(DatarouterUserAccountMapKey::getDatarouterAccountKey).listTo(this.datarouterAccountDao::scanMulti)).include(DatarouterAccount::getEnableUserMappings);
    }
}

