/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.service;

import io.datarouter.auth.storage.account.BaseDatarouterAccountCredentialDao;
import io.datarouter.auth.storage.account.BaseDatarouterAccountDao;
import io.datarouter.auth.storage.account.DatarouterAccountCredential;
import io.datarouter.auth.storage.account.DatarouterAccountCredentialKey;
import io.datarouter.auth.storage.account.DatarouterAccountKey;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DatarouterAccountLastUsedDateService {
    private final BaseDatarouterAccountDao accountDao;
    private final BaseDatarouterAccountCredentialDao credentialDao;
    private final Map<DatarouterAccountKey, Date> lastUsedByAccount;
    private final Map<DatarouterAccountCredentialKey, Date> lastUsedByCredential;

    @Inject
    public DatarouterAccountLastUsedDateService(BaseDatarouterAccountDao accountDao, BaseDatarouterAccountCredentialDao credentialDao) {
        this.accountDao = accountDao;
        this.credentialDao = credentialDao;
        this.lastUsedByAccount = new ConcurrentHashMap<DatarouterAccountKey, Date>();
        this.lastUsedByCredential = new ConcurrentHashMap<DatarouterAccountCredentialKey, Date>();
    }

    public void updateLastUsedDate(DatarouterAccountCredential credential) {
        this.lastUsedByCredential.put((DatarouterAccountCredentialKey)credential.getKey(), new Date());
        this.lastUsedByAccount.put(new DatarouterAccountKey(credential.getAccountName()), new Date());
    }

    public void flush() {
        HashSet<DatarouterAccountKey> accountKeys = new HashSet<DatarouterAccountKey>(this.lastUsedByAccount.keySet());
        this.accountDao.scanMulti(accountKeys).each(account -> account.setLastUsed(this.lastUsedByAccount.get(account.getKey()))).flush(this.accountDao::putMulti);
        accountKeys.forEach(this.lastUsedByAccount::remove);
        HashSet<DatarouterAccountCredentialKey> credentialKeys = new HashSet<DatarouterAccountCredentialKey>(this.lastUsedByCredential.keySet());
        this.credentialDao.scanMulti(credentialKeys).each(credential -> credential.setLastUsed(this.lastUsedByCredential.get(credential.getKey()))).flush(this.credentialDao::putMulti);
        credentialKeys.forEach(this.lastUsedByCredential::remove);
    }
}

