/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.service;

import io.datarouter.auth.service.DatarouterAccountService;
import io.datarouter.auth.storage.account.DatarouterAccountCredential;
import io.datarouter.httpclient.security.DefaultCsrfGenerator;
import io.datarouter.web.security.CsrfValidator;
import io.datarouter.web.security.DefaultCsrfValidator;
import io.datarouter.web.util.http.RequestTool;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;

public class DatarouterAccountCsrfValidator
implements CsrfValidator {
    private final Long requestTimeoutMs;
    private final DatarouterAccountService datarouterAccountService;

    private DatarouterAccountCsrfValidator(Long requestTimeoutMs, DatarouterAccountService accountService) {
        this.requestTimeoutMs = requestTimeoutMs;
        this.datarouterAccountService = accountService;
    }

    public boolean check(HttpServletRequest request) {
        return this.getCsrfValidatorForAccountWithApiKey(request).map(csrfValidator -> csrfValidator.check(request)).orElse(false);
    }

    public Long getRequestTimeMs(HttpServletRequest request) {
        return this.getCsrfValidatorForAccountWithApiKey(request).map(csrfValidator -> csrfValidator.getRequestTimeMs(request)).orElse(null);
    }

    private Optional<DefaultCsrfValidator> getCsrfValidatorForAccountWithApiKey(HttpServletRequest request) {
        String apiKey = RequestTool.getParameterOrHeader((HttpServletRequest)request, (String)"apiKey");
        return this.datarouterAccountService.findAccountCredentialForApiKeyAuth(apiKey).map(DatarouterAccountCredential::getSecretKey).map(secretKey -> () -> secretKey).map(secretKey -> new DefaultCsrfValidator(new DefaultCsrfGenerator(secretKey), this.requestTimeoutMs));
    }

    @Singleton
    public static class DatarouterAccountCsrfValidatorFactory {
        @Inject
        private DatarouterAccountService datarouterAccountService;

        public DatarouterAccountCsrfValidator create(Long requestTimeoutMs) {
            return new DatarouterAccountCsrfValidator(requestTimeoutMs, this.datarouterAccountService);
        }
    }
}

