/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.client;

import io.datarouter.auth.client.BaseSimpleDatarouterClientSettings;
import io.datarouter.auth.service.DefaultDatarouterAccountKeysSupplier;
import io.datarouter.httpclient.client.DatarouterHttpClientSettings;
import io.datarouter.httpclient.client.DatarouterService;
import io.datarouter.storage.setting.DefaultSettingValue;
import io.datarouter.storage.setting.SettingFinder;
import io.datarouter.storage.setting.cached.CachedSetting;
import java.net.URI;

public abstract class BaseDatarouterClientSettings
extends BaseSimpleDatarouterClientSettings
implements DatarouterHttpClientSettings {
    public final CachedSetting<String> endpointDomain;
    public final CachedSetting<String> endpointPath;
    public final CachedSetting<String> apiKey;
    public final CachedSetting<String> privateKey;

    public BaseDatarouterClientSettings(SettingFinder finder, DefaultDatarouterAccountKeysSupplier defaultDatarouterAccountKeys, String settingNodeName, DatarouterService service, DefaultSettingValue<String> endpointDomainDefaults) {
        super(finder, settingNodeName);
        this.endpointDomain = this.registerStrings("endpointDomain", endpointDomainDefaults);
        this.endpointPath = this.registerString("endpointPath", service.getContextPath());
        this.apiKey = this.registerString("apiKey", defaultDatarouterAccountKeys.getDefaultApiKey());
        this.privateKey = this.registerString("privateKey", defaultDatarouterAccountKeys.getDefaultSecretKey());
    }

    public URI getEndpointUrl() {
        return URI.create("https://" + (String)this.endpointDomain.get() + (String)this.endpointPath.get());
    }

    public String getApiKey() {
        return (String)this.apiKey.get();
    }

    public String getPrivateKey() {
        return (String)this.privateKey.get();
    }
}

