/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.service;

import io.datarouter.auth.service.DatarouterAccountService;
import io.datarouter.auth.service.DefaultDatarouterAccountKeysSupplier;
import io.datarouter.auth.storage.account.BaseDatarouterAccountDao;
import io.datarouter.auth.storage.account.DatarouterAccountKey;
import io.datarouter.auth.storage.user.DatarouterUserDao;
import io.datarouter.model.databean.BaseDatabean;
import io.datarouter.util.string.StringTool;
import io.datarouter.web.autoconfig.ConfigScanDto;
import io.datarouter.web.autoconfig.ConfigScanResponseTool;
import io.datarouter.web.user.databean.DatarouterUser;
import io.datarouter.web.user.databean.DatarouterUserKey;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DatarouterAuthConfigScanner {
    @Inject
    private BaseDatarouterAccountDao datarouterAccountDao;
    @Inject
    private DatarouterAccountService datarouterAccountService;
    @Inject
    private DatarouterUserDao datarouterUserDao;
    @Inject
    private DefaultDatarouterAccountKeysSupplier defaultDatarouterAccountKeys;

    public ConfigScanDto checkDatarouterAccountsWithDefaultKeys() {
        List accounts = this.datarouterAccountDao.scan().include(account -> StringTool.equalsCaseInsensitive((String)account.getApiKey(), (String)this.defaultDatarouterAccountKeys.getDefaultApiKey()) || StringTool.equalsCaseInsensitive((String)account.getSecretKey(), (String)this.defaultDatarouterAccountKeys.getDefaultSecretKey())).map(BaseDatabean::getKey).map(DatarouterAccountKey::getAccountName).list();
        if (accounts.isEmpty()) {
            return ConfigScanResponseTool.buildEmptyResponse();
        }
        String header = "Found " + accounts.size() + " account(s) with the default apiKey or secretKey";
        return ConfigScanResponseTool.buildResponse((String)header, (Collection)accounts);
    }

    public ConfigScanDto checkDatarouterAccountsForDuplicateApiKeys() {
        List accountsWithDuplicateKeys = this.datarouterAccountService.getAccountsWithDuplicateApiKey().stream().map(BaseDatabean::getKey).map(DatarouterAccountKey::getAccountName).collect(Collectors.toList());
        if (accountsWithDuplicateKeys.isEmpty()) {
            return ConfigScanResponseTool.buildEmptyResponse();
        }
        String header = "Found " + accountsWithDuplicateKeys.size() + " accounts with duplicate api keys";
        return ConfigScanResponseTool.buildResponse((String)header, accountsWithDuplicateKeys);
    }

    public ConfigScanDto checkForDefaultUserId() {
        Long defaultAdminId = 1L;
        Optional<DatarouterUser> defaultUser = this.datarouterUserDao.find(new DatarouterUserKey(defaultAdminId));
        if (defaultUser.isEmpty()) {
            return ConfigScanResponseTool.buildEmptyResponse();
        }
        String userName = defaultUser.get().getUsername();
        return ConfigScanResponseTool.buildResponse((String)("Found a user with the default admin id=" + defaultAdminId + " and username=" + userName));
    }
}

