/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.service;

import io.datarouter.auth.storage.account.BaseDatarouterAccountDao;
import io.datarouter.auth.storage.account.DatarouterAccount;
import io.datarouter.auth.storage.account.DatarouterAccountKey;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DatarouterAccountLastUsedDateService {
    private final BaseDatarouterAccountDao dao;
    private final Map<DatarouterAccountKey, Date> lastUsedByAccount;

    @Inject
    public DatarouterAccountLastUsedDateService(BaseDatarouterAccountDao dao) {
        this.dao = dao;
        this.lastUsedByAccount = new ConcurrentHashMap<DatarouterAccountKey, Date>();
    }

    public void updateLastUsedDate(DatarouterAccountKey datarouterAccountKey) {
        this.lastUsedByAccount.put(datarouterAccountKey, new Date());
    }

    public void flush() {
        List<DatarouterAccount> accounts = this.dao.getMulti(this.lastUsedByAccount.keySet());
        accounts.forEach(account -> account.setLastUsed(this.lastUsedByAccount.remove(account.getKey())));
        this.dao.putMulti(accounts);
    }
}

