/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.service;

import io.datarouter.auth.service.DatarouterAccountCounters;
import io.datarouter.auth.service.DatarouterAccountService;
import io.datarouter.auth.storage.accountpermission.DatarouterAccountPermissionKey;
import io.datarouter.util.tuple.Pair;
import io.datarouter.web.dispatcher.ApiKeyPredicate;
import io.datarouter.web.dispatcher.DispatchRule;
import io.datarouter.web.util.http.RequestTool;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;

@Singleton
public class DatarouterAccountApiKeyPredicate
implements ApiKeyPredicate {
    private final DatarouterAccountService datarouterAccountService;
    private final DatarouterAccountCounters datarouterAccountCounters;

    @Inject
    public DatarouterAccountApiKeyPredicate(DatarouterAccountService datarouterAccountService, DatarouterAccountCounters datarouterAccountCounters) {
        this.datarouterAccountService = datarouterAccountService;
        this.datarouterAccountCounters = datarouterAccountCounters;
    }

    public Pair<Boolean, String> check(DispatchRule rule, HttpServletRequest request) {
        String apiKeyCandidate = RequestTool.getParameterOrHeader((HttpServletRequest)request, (String)"apiKey");
        if (apiKeyCandidate == null) {
            return new Pair((Object)false, (Object)"key not found");
        }
        Optional endpoint = rule.getPersistentString();
        return new Pair((Object)this.check(endpoint, apiKeyCandidate).isPresent(), (Object)("no account for " + ApiKeyPredicate.obfuscate((String)apiKeyCandidate)));
    }

    public Optional<String> check(Optional<String> endpoint, String apiKeyCandidate) {
        Optional permission = this.datarouterAccountService.scanPermissionsForApiKey(apiKeyCandidate).include(candidate -> this.isValidEndpoint((DatarouterAccountPermissionKey)((Object)candidate), endpoint)).findAny();
        permission.ifPresent(this.datarouterAccountCounters::incPermissionUsage);
        return permission.map(DatarouterAccountPermissionKey::getAccountName);
    }

    private boolean isValidEndpoint(DatarouterAccountPermissionKey candidate, Optional<String> endpoint) {
        boolean isWildcard = candidate.getEndpoint().equals("all");
        boolean matches = endpoint.map(candidate.getEndpoint()::equals).orElse(false);
        return isWildcard || matches;
    }
}

