/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.service.deprovisioning;

import io.datarouter.auth.service.deprovisioning.UserDeprovisioningStrategy;
import io.datarouter.auth.storage.deprovisioneduser.DeprovisionedUser;
import io.datarouter.auth.storage.deprovisioneduser.DeprovisionedUserDao;
import io.datarouter.auth.storage.deprovisioneduser.DeprovisionedUserKey;
import io.datarouter.auth.storage.user.DatarouterUserDao;
import io.datarouter.scanner.Scanner;
import io.datarouter.web.user.databean.DatarouterUser;
import io.datarouter.web.user.session.service.RoleManager;
import io.datarouter.web.user.session.service.UserSessionService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DatarouterUserDeprovisioningStrategy
implements UserDeprovisioningStrategy {
    @Inject
    private DatarouterUserDao datarouterUserDao;
    @Inject
    private DeprovisionedUserDao deprovisionedUserDao;
    @Inject
    private RoleManager roleManager;
    @Inject
    private UserSessionService userSessionService;

    @Override
    public List<String> flagUsers(List<String> usernames) {
        return this.doFlagOrDeprovision(usernames, false);
    }

    @Override
    public List<String> deprovisionUsers(List<String> usernames) {
        return this.doFlagOrDeprovision(usernames, true);
    }

    private List<String> doFlagOrDeprovision(List<String> usernames, boolean shouldDeprovision) {
        this.userSessionService.deleteUserSessions(usernames);
        ArrayList<DeprovisionedUser> deprovisionedUsers = new ArrayList<DeprovisionedUser>();
        List users = (List)Scanner.of(usernames).map(DatarouterUser.DatarouterUserByUsernameLookup::new).listTo(this.datarouterUserDao::getMultiByUsername);
        ArrayList<String> deprovisionedUsernames = new ArrayList<String>();
        users.forEach(user -> {
            deprovisionedUsers.add(new DeprovisionedUser(user.getUsername(), user.getRoles(), shouldDeprovision ? DeprovisionedUser.UserDeprovisioningStatus.DEPROVISIONED : DeprovisionedUser.UserDeprovisioningStatus.FLAGGED));
            user.setRoles(List.of());
            user.setEnabled(Boolean.valueOf(false));
            deprovisionedUsernames.add(user.getUsername());
        });
        this.deprovisionedUserDao.putMulti(deprovisionedUsers);
        if (shouldDeprovision) {
            this.datarouterUserDao.putMulti(users);
        }
        return deprovisionedUsernames;
    }

    @Override
    public List<String> restoreUsers(List<String> usernames) {
        Set validRoles = this.roleManager.getAllRoles();
        Map deprovisionedRolesByUsername = ((Scanner)Scanner.of(usernames).map(DeprovisionedUserKey::new).listTo(this.deprovisionedUserDao::scanWithPrefixes)).include(user -> user.getStatus() == DeprovisionedUser.UserDeprovisioningStatus.DEPROVISIONED).toMap(DeprovisionedUser::getUsername, DeprovisionedUser::getRoles);
        Map datarouterUserByUsername = ((List)Scanner.of(usernames).map(DatarouterUser.DatarouterUserByUsernameLookup::new).listTo(this.datarouterUserDao::getMultiByUsername)).stream().collect(Collectors.toMap(DatarouterUser::getUsername, Function.identity()));
        return Scanner.of(usernames).include(deprovisionedRolesByUsername::containsKey).include(datarouterUserByUsername::containsKey).map(username -> {
            List rolesToRestore = ((Set)deprovisionedRolesByUsername.get(username)).stream().filter(validRoles::contains).collect(Collectors.toList());
            DatarouterUser datarouterUser = (DatarouterUser)datarouterUserByUsername.get(username);
            datarouterUser.setRoles(rolesToRestore);
            datarouterUser.setEnabled(Boolean.valueOf(true));
            return datarouterUser;
        }).flush(this.datarouterUserDao::putMulti).map(DatarouterUser::getUsername).flush(this.deprovisionedUserDao::deleteMultiUsernames).list();
    }
}

