/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.service;

import io.datarouter.auth.service.DatarouterUserEditService;
import io.datarouter.auth.service.DatarouterUserService;
import io.datarouter.auth.storage.permissionrequest.DatarouterPermissionRequest;
import io.datarouter.auth.storage.permissionrequest.DatarouterPermissionRequestDao;
import io.datarouter.auth.storage.user.DatarouterUserDao;
import io.datarouter.auth.storage.userhistory.DatarouterUserHistory;
import io.datarouter.auth.storage.userhistory.DatarouterUserHistoryDao;
import io.datarouter.auth.storage.userhistory.DatarouterUserHistoryKey;
import io.datarouter.model.databean.BaseDatabean;
import io.datarouter.scanner.Scanner;
import io.datarouter.web.email.DatarouterHtmlEmailService;
import io.datarouter.web.html.email.J2HtmlDatarouterEmailBuilder;
import io.datarouter.web.user.databean.DatarouterUser;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DatarouterUserHistoryService {
    @Inject
    private DatarouterUserDao baseDatarouterUserDao;
    @Inject
    private DatarouterUserHistoryDao baseDatarouterUserHistoryDao;
    @Inject
    private DatarouterPermissionRequestDao permissionRequestDao;
    @Inject
    private DatarouterUserService datarouterUserService;
    @Inject
    private DatarouterHtmlEmailService htmlEmailService;
    @Inject
    private DatarouterUserEditService userEditService;

    public Map<DatarouterPermissionRequest, Optional<String>> getResolvedRequestToHistoryChangesMap(List<DatarouterPermissionRequest> requests) {
        Map historyMap = Scanner.of(requests).map(DatarouterPermissionRequest::toUserHistoryKey).map(key -> key.orElse(null)).include(Objects::nonNull).batch(100).map(this.baseDatarouterUserHistoryDao::getMulti).concat(Scanner::of).toMap(BaseDatabean::getKey, DatarouterUserHistory::getChanges);
        return Scanner.of(requests).deduplicate().toMap(Function.identity(), request -> request.toUserHistoryKey().map(historyKey -> historyMap.getOrDefault(historyKey, request.getResolution().getPersistentString())));
    }

    public Optional<String> getResolutionDescription(DatarouterPermissionRequest request, Map<DatarouterUserHistoryKey, String> historyMap) {
        return request.toUserHistoryKey().map(historyKey -> historyMap.getOrDefault(historyKey, request.getResolution().getPersistentString()));
    }

    public void recordCreate(DatarouterUser user, Long editorId, String description) {
        this.baseDatarouterUserDao.put(user);
        this.baseDatarouterUserHistoryDao.put(new DatarouterUserHistory(user.getId(), user.getCreated(), editorId, DatarouterUserHistory.DatarouterUserChangeType.CREATE, description));
    }

    public void recordPasswordChange(DatarouterUser user, DatarouterUserHistory history, String signinUrl) {
        this.recordEdit(user, history);
        this.sendPasswordChangeEmail(user, history, signinUrl);
    }

    public void recordRoleEdit(DatarouterUser user, DatarouterUserHistory history, String signinUrl) {
        this.recordEdit(user, history);
        this.sendRoleEditEmail(user, history, signinUrl);
    }

    private void recordEdit(DatarouterUser user, DatarouterUserHistory history) {
        this.baseDatarouterUserDao.put(user);
        this.baseDatarouterUserHistoryDao.put(history);
        this.permissionRequestDao.scanOpenPermissionRequestsForUser(((DatarouterUserHistoryKey)history.getKey()).getUserId()).map(history::resolvePermissionRequest).flush(this.permissionRequestDao::putMulti);
    }

    private void sendPasswordChangeEmail(DatarouterUser user, DatarouterUserHistory history, String signInUrl) {
        String from = user.getUsername();
        String to = user.getUsername();
        DatarouterUser editor = this.datarouterUserService.getUserById(history.getEditor());
        ContainerTag p1 = TagCreator.p((String)String.format("Your user (%s) password has been changed by user %s (%s).", user.getUsername(), editor.getId(), editor.getUsername()));
        ContainerTag p2 = TagCreator.p((String)("Changes: " + history.getChanges()));
        ContainerTag content = TagCreator.div((DomContent[])new DomContent[]{p1, p2, DatarouterUserHistoryService.makeSignInParagraph(signInUrl)});
        J2HtmlDatarouterEmailBuilder emailBuilder = this.htmlEmailService.startEmailBuilder().withSubject(this.userEditService.getPermissionRequestEmailSubject(user)).withTitle("Password Changed").withTitleHref(signInUrl).withContent(content);
        this.htmlEmailService.trySendJ2Html(from, to, emailBuilder);
    }

    private void sendRoleEditEmail(DatarouterUser user, DatarouterUserHistory history, String signInUrl) {
        DatarouterUser editor = this.datarouterUserService.getUserById(history.getEditor());
        String from = user.getUsername();
        String to = this.userEditService.getUserEditEmailRecipients(user, editor);
        ContainerTag p1 = TagCreator.p((String)String.format("%s permissions have been edited by %s", user.getUsername(), editor.getUsername()));
        ContainerTag p2 = TagCreator.p((String)("Changes: " + history.getChanges()));
        ContainerTag content = TagCreator.div((DomContent[])new DomContent[]{p1, p2, DatarouterUserHistoryService.makeSignInParagraph(signInUrl)});
        J2HtmlDatarouterEmailBuilder emailBuilder = this.htmlEmailService.startEmailBuilder().withSubject(this.userEditService.getPermissionRequestEmailSubject(user)).withTitle("Permissions Changed").withTitleHref(signInUrl).withContent(content);
        this.htmlEmailService.trySendJ2Html(from, to, emailBuilder);
    }

    private static ContainerTag makeSignInParagraph(String signInUrl) {
        return TagCreator.p((DomContent[])new DomContent[]{TagCreator.text((String)"Please sign in again to refresh your session: "), TagCreator.a((String)"sign in").withHref(signInUrl)});
    }
}

