/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.web;

import io.datarouter.auth.config.DatarouterAuthFiles;
import io.datarouter.auth.config.DatarouterAuthPaths;
import io.datarouter.auth.service.DatarouterUserEditService;
import io.datarouter.auth.service.DatarouterUserInfo;
import io.datarouter.auth.service.DatarouterUserService;
import io.datarouter.auth.storage.permissionrequest.DatarouterPermissionRequest;
import io.datarouter.auth.storage.permissionrequest.DatarouterPermissionRequestDao;
import io.datarouter.auth.storage.permissionrequest.DatarouterPermissionRequestKey;
import io.datarouter.httpclient.client.DatarouterService;
import io.datarouter.storage.config.DatarouterAdministratorEmailService;
import io.datarouter.storage.config.DatarouterProperties;
import io.datarouter.util.string.StringTool;
import io.datarouter.web.email.DatarouterHtmlEmailService;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.handler.mav.imp.GlobalRedirectMav;
import io.datarouter.web.handler.mav.imp.InContextRedirectMav;
import io.datarouter.web.handler.mav.imp.MessageMav;
import io.datarouter.web.handler.types.optional.OptionalLong;
import io.datarouter.web.handler.types.optional.OptionalString;
import io.datarouter.web.html.email.J2HtmlDatarouterEmailBuilder;
import io.datarouter.web.user.authenticate.PermissionRequestAdditionalEmailsSupplier;
import io.datarouter.web.user.authenticate.config.DatarouterAuthenticationConfig;
import io.datarouter.web.user.databean.DatarouterUser;
import io.datarouter.web.user.detail.DatarouterUserExternalDetailService;
import io.datarouter.web.user.role.DatarouterUserRole;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import java.util.Comparator;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatarouterPermissionRequestHandler
extends BaseHandler {
    private static final Logger logger = LoggerFactory.getLogger(DatarouterPermissionRequestHandler.class);
    private static final String P_REASON = "reason";
    private static final String EMAIL_TITLE = "Permission Request";
    @Inject
    private DatarouterAuthenticationConfig authenticationConfig;
    @Inject
    private DatarouterPermissionRequestDao datarouterPermissionRequestDao;
    @Inject
    private DatarouterUserService datarouterUserService;
    @Inject
    private DatarouterHtmlEmailService htmlEmailService;
    @Inject
    private DatarouterProperties datarouterProperties;
    @Inject
    private DatarouterAuthFiles files;
    @Inject
    private DatarouterAuthPaths paths;
    @Inject
    private DatarouterUserEditService userEditService;
    @Inject
    private DatarouterUserInfo datarouterUserInfo;
    @Inject
    private DatarouterAdministratorEmailService administratorEmailService;
    @Inject
    private DatarouterUserExternalDetailService userExternalDetailService;
    @Inject
    private PermissionRequestAdditionalEmailsSupplier permissionRequestAdditionalEmails;
    @Inject
    private DatarouterService datarouterService;

    @BaseHandler.Handler(defaultHandler=true)
    private Mav showForm(OptionalString deniedUrl, OptionalString allowedRoles) {
        if (!this.authenticationConfig.useDatarouterAuthentication()) {
            return new MessageMav(this.noDatarouterAuthentication());
        }
        Mav mav = new Mav(this.files.jsp.authentication.permissionRequestJsp);
        mav.put("serviceName", (Object)this.datarouterService.getName());
        mav.put("permissionRequestPath", (Object)this.paths.permissionRequest.toSlashedString());
        Optional defaultSpecifics = deniedUrl.map(url -> "I tried to go to this URL: " + url + "." + allowedRoles.map(" These are its allowed roles at the time of this request: "::concat).orElse(""));
        mav.put("defaultSpecifics", (Object)defaultSpecifics);
        DatarouterUser user = this.getCurrentUser();
        mav.put("currentRequest", (Object)((DatarouterPermissionRequest)this.datarouterPermissionRequestDao.scanOpenPermissionRequestsForUser(user.getId()).max(Comparator.comparing(request -> ((DatarouterPermissionRequestKey)request.getKey()).getRequestTime())).orElse(null)));
        Set additionalPermissionEmails = (Set)this.permissionRequestAdditionalEmails.get();
        mav.put("email", (Object)this.administratorEmailService.getAdministratorEmailAddressesCsv(additionalPermissionEmails));
        mav.put("submitPath", (Object)this.paths.permissionRequest.submit.toSlashedStringWithoutLeadingSlash());
        mav.put("declinePath", (Object)this.paths.permissionRequest.declineAll.toSlashedStringWithoutLeadingSlash());
        return mav;
    }

    @BaseHandler.Handler
    private Mav submit(OptionalString specifics) {
        if (!this.authenticationConfig.useDatarouterAuthentication()) {
            return new MessageMav(this.noDatarouterAuthentication());
        }
        String reason = this.params.required(P_REASON);
        if (StringTool.isEmpty((String)reason)) {
            throw new IllegalArgumentException("Reason is required.");
        }
        String specificString = (String)specifics.orElse((Object)"");
        DatarouterUser user = this.getCurrentUser();
        this.datarouterPermissionRequestDao.createPermissionRequest(new DatarouterPermissionRequest(user.getId(), new Date(), "reason: " + reason + ", specifics: " + specificString, null, null));
        this.sendRequestEmail(user, reason, specificString);
        if (user.getRoles().size() > 1) {
            return new InContextRedirectMav(this.request, this.paths.home);
        }
        return this.showForm(new OptionalString(null), new OptionalString(null));
    }

    @BaseHandler.Handler
    private Mav declineAll(OptionalLong userId, OptionalString redirectPath) {
        if (!this.authenticationConfig.useDatarouterAuthentication()) {
            return new MessageMav(this.noDatarouterAuthentication());
        }
        DatarouterUser currentUser = this.getCurrentUser();
        if (!((Long)userId.orElse((Object)currentUser.getId())).equals(currentUser.getId()) && !currentUser.getRoles().contains(DatarouterUserRole.DATAROUTER_ADMIN.getRole())) {
            return new MessageMav("You do not have permission to decline this request.");
        }
        this.datarouterPermissionRequestDao.declineAll((Long)userId.orElse((Object)currentUser.getId()));
        DatarouterUser editedUser = currentUser;
        if (!((Long)userId.orElse((Object)currentUser.getId())).equals(this.getCurrentUser().getId())) {
            editedUser = this.datarouterUserInfo.getUserById((Long)userId.get()).get();
        }
        this.sendDeclineEmail(editedUser, currentUser);
        if (redirectPath.isEmpty()) {
            if (currentUser.getRoles().size() > 1) {
                return new InContextRedirectMav(this.request, this.paths.home);
            }
            return this.showForm(new OptionalString(null), new OptionalString(null));
        }
        return new GlobalRedirectMav((String)redirectPath.get());
    }

    @BaseHandler.Handler
    private SuccessAndMessageDto declinePermissionRequests(String userId) {
        long userIdLong = Long.parseLong(userId);
        if (!this.authenticationConfig.useDatarouterAuthentication()) {
            return new SuccessAndMessageDto(false, this.noDatarouterAuthentication());
        }
        DatarouterUser currentUser = this.getCurrentUser();
        if (userIdLong != currentUser.getId() && !currentUser.getRoles().contains(DatarouterUserRole.DATAROUTER_ADMIN.getRole())) {
            return new SuccessAndMessageDto(false, "You do not have permission to decline this request.");
        }
        this.datarouterPermissionRequestDao.declineAll(userIdLong);
        DatarouterUser editedUser = currentUser;
        if (userIdLong != this.getCurrentUser().getId()) {
            editedUser = this.datarouterUserInfo.getUserById(userIdLong).get();
        }
        this.sendDeclineEmail(editedUser, currentUser);
        return new SuccessAndMessageDto();
    }

    private DatarouterUser getCurrentUser() {
        return this.datarouterUserService.getAndValidateCurrentUser(this.getSessionInfo().getRequiredSession());
    }

    private void sendRequestEmail(DatarouterUser user, String reason, String specifics) {
        String userProfileUrl = this.userExternalDetailService.getUserProfileUrl(user).orElse(null);
        String userEmail = user.getUsername();
        String recipients = this.userEditService.getUserEditEmailRecipients(user);
        String primaryHref = this.htmlEmailService.startLinkBuilder().withLocalPath(this.paths.admin.editUser.toSlashedString()).withParam("userId", "" + user.getId()).build();
        ContainerTag content = TagCreator.div().with((DomContent)TagCreator.p((String)("Service: " + this.datarouterService.getName()))).with((DomContent)TagCreator.p((String)("User " + userEmail + " requests elevated permissions."))).condWith(userProfileUrl != null, (DomContent)TagCreator.p((DomContent[])new DomContent[]{TagCreator.text((String)"User Profile: "), TagCreator.a((String)"link").withHref(userProfileUrl)})).with((DomContent)TagCreator.p((String)("Reason: " + reason))).condWith(StringTool.notEmpty((String)specifics), (DomContent)TagCreator.p((String)("Specifics: " + specifics))).with((DomContent)TagCreator.p((DomContent[])new DomContent[]{TagCreator.text((String)"Edit here"), TagCreator.a((String)"link").withHref(primaryHref)}));
        J2HtmlDatarouterEmailBuilder emailBuilder = this.htmlEmailService.startEmailBuilder().withSubject(this.userEditService.getPermissionRequestEmailSubject(user)).withTitle(EMAIL_TITLE).withTitleHref(primaryHref).withContent(content);
        this.htmlEmailService.trySendJ2Html(userEmail, recipients, emailBuilder);
    }

    private void sendDeclineEmail(DatarouterUser editedUser, DatarouterUser currentUser) {
        String from = editedUser.getUsername();
        String to = this.userEditService.getUserEditEmailRecipients(editedUser);
        String titleHref = this.htmlEmailService.startLinkBuilder().withLocalPath(this.paths.admin.editUser.toSlashedString()).withParam("userId", "" + editedUser.getId()).build();
        String message = String.format("Permission requests declined for user %s by user %s", editedUser.getUsername(), currentUser.getUsername());
        ContainerTag content = TagCreator.p((String)message);
        J2HtmlDatarouterEmailBuilder emailBuilder = this.htmlEmailService.startEmailBuilder().withSubject(this.userEditService.getPermissionRequestEmailSubject(editedUser)).withTitle(EMAIL_TITLE).withTitleHref(titleHref).withContent(content);
        this.htmlEmailService.trySendJ2Html(from, to, emailBuilder);
    }

    private String noDatarouterAuthentication() {
        logger.warn("{} went to non-DR permission request page.", (Object)this.getSessionInfo().getRequiredSession().getUsername());
        return "This is only available when using datarouter authentication. Please email " + this.datarouterProperties.getAdministratorEmail() + " for assistance.";
    }

    public static class PermissionRequestDto {
        public final Date requestTime;
        public final String requestText;
        public final Date resolutionTime;
        public final String resolution;

        public PermissionRequestDto(Date requestTime, String requestText, Date resolutionTime, String resolution) {
            this.requestTime = requestTime;
            this.requestText = requestText;
            this.resolutionTime = resolutionTime;
            this.resolution = resolution;
        }
    }

    private static class SuccessAndMessageDto {
        public final Boolean success;
        public final String message;

        protected SuccessAndMessageDto() {
            this.success = true;
            this.message = "";
        }

        protected SuccessAndMessageDto(boolean success, String message) {
            this.success = success;
            this.message = Objects.requireNonNull(message);
        }
    }
}

