/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.service;

import java.util.List;
import java.util.function.Supplier;
import javax.inject.Singleton;

public interface UserDeprovisioningService {
    public List<String> flagUsersForDeprovisioning(List<String> var1);

    public List<String> deprovisionUsers(List<String> var1);

    default public List<String> flagOrDeprovisionUsers(List<String> usernames) {
        if (this.shouldFlagUsersInsteadOfDeprovisioning()) {
            return this.flagUsersForDeprovisioning(usernames);
        }
        return this.deprovisionUsers(usernames);
    }

    public List<String> restoreDeprovisionedUsers(List<String> var1);

    public boolean shouldFlagUsersInsteadOfDeprovisioning();

    @Singleton
    public static class NoOpUserDeprovisioningService
    implements UserDeprovisioningService {
        @Override
        public List<String> flagUsersForDeprovisioning(List<String> usernames) {
            return List.of();
        }

        @Override
        public List<String> deprovisionUsers(List<String> usernames) {
            return List.of();
        }

        @Override
        public List<String> restoreDeprovisionedUsers(List<String> usernames) {
            return List.of();
        }

        @Override
        public boolean shouldFlagUsersInsteadOfDeprovisioning() {
            return false;
        }
    }

    public static class ShouldFlagUsersInsteadOfDeprovisioningSupplier
    implements Supplier<Boolean> {
        private final boolean shouldFlagUsersInsteadOfDeprovisioning;

        public ShouldFlagUsersInsteadOfDeprovisioningSupplier(boolean shouldFlagUsersInsteadOfDeprovisioning) {
            this.shouldFlagUsersInsteadOfDeprovisioning = shouldFlagUsersInsteadOfDeprovisioning;
        }

        @Override
        public Boolean get() {
            return this.shouldFlagUsersInsteadOfDeprovisioning;
        }
    }
}

