/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.web.deprovisioning;

import java.text.Collator;
import java.util.Comparator;
import java.util.List;

public class DeprovisionedUserDto {
    public static final Comparator<DeprovisionedUserDto> COMPARATOR = new DeprovisionedUserDtoComparator();
    public final String username;
    public final List<String> roles;
    public final UserDeprovisioningStatusDto status;

    public DeprovisionedUserDto(String username, List<String> roles, UserDeprovisioningStatusDto status) {
        this.username = username;
        this.roles = List.copyOf(roles);
        this.status = status;
    }

    private static class DeprovisionedUserDtoComparator
    implements Comparator<DeprovisionedUserDto> {
        private static final Collator COLLATOR = Collator.getInstance();

        private DeprovisionedUserDtoComparator() {
        }

        @Override
        public int compare(DeprovisionedUserDto first, DeprovisionedUserDto second) {
            return COLLATOR.compare(first.username, second.username);
        }
    }

    public static enum UserDeprovisioningStatusDto {
        DEPROVISIONED,
        FLAGGED,
        UNRESTORABLE;

    }
}

