/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.web;

import io.datarouter.auth.config.DatarouterAuthFiles;
import io.datarouter.auth.config.DatarouterAuthPaths;
import io.datarouter.auth.service.DatarouterAccountService;
import io.datarouter.auth.service.DatarouterUserCreationService;
import io.datarouter.auth.service.DatarouterUserEditService;
import io.datarouter.auth.service.DatarouterUserHistoryService;
import io.datarouter.auth.service.DatarouterUserService;
import io.datarouter.auth.service.UserInfo;
import io.datarouter.auth.storage.account.BaseDatarouterAccountDao;
import io.datarouter.auth.storage.account.DatarouterAccount;
import io.datarouter.auth.storage.account.DatarouterAccountKey;
import io.datarouter.auth.storage.permissionrequest.DatarouterPermissionRequest;
import io.datarouter.auth.storage.permissionrequest.DatarouterPermissionRequestDao;
import io.datarouter.auth.web.CreateUserFormHtml;
import io.datarouter.httpclient.path.PathNode;
import io.datarouter.storage.servertype.ServerTypeDetector;
import io.datarouter.util.string.StringTool;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.handler.mav.imp.InContextRedirectMav;
import io.datarouter.web.handler.mav.imp.MessageMav;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4PageFactory;
import io.datarouter.web.html.react.bootstrap4.Bootstrap4ReactPageFactory;
import io.datarouter.web.user.authenticate.config.DatarouterAuthenticationConfig;
import io.datarouter.web.user.databean.DatarouterUser;
import io.datarouter.web.user.databean.DatarouterUserKey;
import io.datarouter.web.user.session.service.Role;
import io.datarouter.web.user.session.service.RoleManager;
import io.datarouter.web.util.http.ResponseTool;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.servlet.http.HttpServletResponse;

public class AdminEditUserHandler
extends BaseHandler {
    private static final String AUTHENTICATION_CONFIG = "authenticationConfig";
    private static final String DATAROUTER_USER_ROLES = "datarouterUserRoles";
    private static final String USER = "user";
    private static final String USER_ROLES = "userRoles";
    @Inject
    private BaseDatarouterAccountDao datarouterAccountDao;
    @Inject
    private DatarouterAccountService datarouterAccountService;
    @Inject
    private DatarouterAuthenticationConfig authenticationConfig;
    @Inject
    private DatarouterUserCreationService datarouterUserCreationService;
    @Inject
    private DatarouterUserService datarouterUserService;
    @Inject
    private RoleManager roleManager;
    @Inject
    private DatarouterUserEditService datarouterUserEditService;
    @Inject
    private DatarouterUserHistoryService datarouterUserHistoryService;
    @Inject
    private DatarouterAuthPaths paths;
    @Inject
    private DatarouterAuthFiles files;
    @Inject
    private ServerTypeDetector serverTypeDetector;
    @Inject
    private Bootstrap4PageFactory pageFactory;
    @Inject
    private Bootstrap4ReactPageFactory reactPageFactory;
    @Inject
    private DatarouterPermissionRequestDao datarouterPermissionRequestDao;
    @Inject
    private UserInfo userInfo;

    @BaseHandler.Handler
    private Mav viewUsers() {
        return this.reactPageFactory.startBuilder(this.request).withTitle("Datarouter - Users").withReactScript(this.files.js.viewUsersJsx).buildMav();
    }

    @BaseHandler.Handler
    private List<DatarouterUserListEntry> listUsers() {
        Set<Long> userIdsWithPermissionRequests = this.datarouterPermissionRequestDao.getUserIdsWithPermissionRequests();
        return this.userInfo.scanAllUsers(false, this.roleManager.getAllRoles()).map(user -> new DatarouterUserListEntry(user.getId().toString(), user.getUsername(), user.getToken(), userIdsWithPermissionRequests.contains(user.getId()))).list();
    }

    @BaseHandler.Handler
    private Mav createUser() {
        if (this.serverTypeDetector.mightBeProduction()) {
            return this.pageFactory.message(this.request, "This is not supported on production");
        }
        CreateUserFormHtml template = new CreateUserFormHtml(AdminEditUserHandler.roleToStrings(this.roleManager.getConferrableRoles(this.getCurrentUser().getRoles())), this.authenticationConfig, this.paths.admin.createUserSubmit.toSlashedStringAfter((PathNode)this.paths.admin, false));
        return this.pageFactory.startBuilder(this.request).withTitle("Datarouter - Create User").withContent(template.build()).buildMav();
    }

    @BaseHandler.Handler
    private Mav createUserSubmit() {
        if (this.serverTypeDetector.mightBeProduction()) {
            return this.pageFactory.message(this.request, "This is not supported on production");
        }
        DatarouterUser currentUser = this.getCurrentUser();
        if (!this.roleManager.isAdmin(currentUser.getRoles()).booleanValue()) {
            this.handleInvalidRequest();
        }
        String username = this.params.required(this.authenticationConfig.getUsernameParam());
        String password = this.params.required(this.authenticationConfig.getPasswordParam());
        String[] roleStrings = this.params.optionalArray(this.authenticationConfig.getUserRolesParam()).orElse(new String[0]);
        Set<Role> requestedRoles = Arrays.stream(roleStrings).map(arg_0 -> ((RoleManager)this.roleManager).getRoleFromPersistentString(arg_0)).collect(Collectors.toSet());
        boolean enabled = this.params.optionalBoolean(this.authenticationConfig.getEnabledParam(), Boolean.valueOf(true));
        this.datarouterUserCreationService.createManualUser(currentUser, username, password, requestedRoles, enabled);
        return new InContextRedirectMav(this.request, this.paths.admin.viewUsers);
    }

    @BaseHandler.Handler
    private Mav editUser() {
        DatarouterUser currentUser = this.getCurrentUser();
        Long userId = this.params.optionalLong(this.authenticationConfig.getUserIdParam(), currentUser.getId());
        DatarouterUser userToEdit = this.datarouterUserService.getUserById(userId);
        this.checkEditPermission(currentUser, userToEdit, this.datarouterUserService::canEditUser);
        Mav mav = new Mav(this.files.jsp.authentication.editUserFormJsp);
        mav.put(USER, (Object)userToEdit);
        ArrayList<DatarouterPermissionRequest> currentRequests = new ArrayList<DatarouterPermissionRequest>();
        ArrayList<DatarouterPermissionRequest> pastRequests = new ArrayList<DatarouterPermissionRequest>();
        this.datarouterPermissionRequestDao.scanPermissionRequestsForUser(userId).forEach(request -> {
            if (request.getResolution() == null) {
                currentRequests.add((DatarouterPermissionRequest)((Object)request));
            } else {
                pastRequests.add((DatarouterPermissionRequest)((Object)request));
            }
        });
        currentRequests.sort(DatarouterPermissionRequest.REVERSE_CHRONOLOGICAL_COMPARATOR);
        TreeMap<DatarouterPermissionRequest, String> resolvedRequests = new TreeMap<DatarouterPermissionRequest, String>(DatarouterPermissionRequest.REVERSE_CHRONOLOGICAL_COMPARATOR);
        resolvedRequests.putAll(this.datarouterUserHistoryService.getResolvedRequestToHistoryChangesMap(pastRequests));
        mav.put("currentRequests", currentRequests);
        mav.put("resolvedRequests", resolvedRequests);
        mav.put(AUTHENTICATION_CONFIG, (Object)this.authenticationConfig);
        this.addPaths(mav);
        mav.put(DATAROUTER_USER_ROLES, AdminEditUserHandler.roleToStrings(this.roleManager.getConferrableRoles(currentUser.getRoles())));
        mav.put(USER_ROLES, AdminEditUserHandler.roleToStrings(userToEdit.getRoles()));
        mav.put("datarouterAccounts", (Object)this.datarouterAccountDao.scan().sorted(Comparator.comparing(accnt -> ((DatarouterAccountKey)accnt.getKey()).getAccountName(), String.CASE_INSENSITIVE_ORDER)).include(DatarouterAccount::getEnableUserMappings).list());
        mav.put("userAccounts", this.datarouterAccountService.findAccountNamesForUser(new DatarouterUserKey(userId)));
        mav.put("permissionRequestPage", (Object)(String.valueOf(this.request.getContextPath()) + this.paths.permissionRequest.toSlashedString()));
        mav.put("thisPagePath", (Object)(String.valueOf(this.request.getRequestURI()) + (this.request.getQueryString() == null ? "" : "?" + this.request.getQueryString())));
        mav.put("declinePath", (Object)(String.valueOf(this.request.getContextPath()) + this.paths.permissionRequest.declineAll.toSlashedString()));
        return mav;
    }

    @BaseHandler.Handler
    private Mav editUserSubmit() {
        Long userId = this.params.requiredLong(this.authenticationConfig.getUserIdParam());
        Boolean enabled = this.params.optionalBoolean(this.authenticationConfig.getEnabledParam(), Boolean.valueOf(false));
        DatarouterUser currentUser = this.getCurrentUser();
        DatarouterUser userToEdit = this.datarouterUserService.getUserById(userId);
        this.checkEditPermission(currentUser, userToEdit, this.datarouterUserService::canEditUser);
        String[] roleStrings = this.params.optionalArray(this.authenticationConfig.getUserRolesParam()).orElse(new String[0]);
        Set<Role> userRoles = Arrays.stream(roleStrings).map(arg_0 -> ((RoleManager)this.roleManager).getRoleFromPersistentString(arg_0)).collect(Collectors.toSet());
        Set<DatarouterAccountKey> requestedAccounts = this.params.optionalArray("accounts").map(Arrays::stream).orElseGet(Stream::empty).map(DatarouterAccountKey::new).collect(Collectors.toSet());
        this.datarouterUserEditService.editUser(userToEdit, currentUser, userRoles, enabled, this.getSigninUrl(), requestedAccounts);
        return new InContextRedirectMav(this.request, String.valueOf(this.paths.admin.editUser.toSlashedString()) + "?userId=" + userId);
    }

    @BaseHandler.Handler
    private Mav resetPassword() {
        DatarouterUser currentUser = this.getCurrentUser();
        Long userId = this.params.optionalLong(this.authenticationConfig.getUserIdParam(), currentUser.getId());
        DatarouterUser userToEdit = this.datarouterUserService.getUserById(userId);
        this.checkEditPermission(currentUser, userToEdit, this.datarouterUserService::canEditUserPassword);
        Mav mav = new Mav(this.files.jsp.authentication.resetPasswordFormJsp);
        mav.put("enabled", (Object)this.datarouterUserService.canHavePassword(userToEdit));
        mav.put(USER, (Object)userToEdit);
        mav.put(AUTHENTICATION_CONFIG, (Object)this.authenticationConfig);
        this.addPaths(mav);
        return mav;
    }

    @BaseHandler.Handler
    private Mav resetPasswordSubmit() {
        String password = this.params.required(this.authenticationConfig.getPasswordParam());
        Long userId = this.params.requiredLong(this.authenticationConfig.getUserIdParam());
        DatarouterUser currentUser = this.getCurrentUser();
        DatarouterUser userToEdit = this.datarouterUserService.getUserById(userId);
        this.checkEditPermission(currentUser, userToEdit, this.datarouterUserService::canEditUserPassword);
        if (!this.datarouterUserService.canHavePassword(userToEdit)) {
            return new MessageMav("This user is externally authenticated and cannot have a password.");
        }
        this.datarouterUserEditService.changePassword(userToEdit, currentUser, password, this.getSigninUrl());
        String path = this.pathBuilder(this.paths.admin.editUser.toSlashedString(), this.authenticationConfig.getUserIdParam(), userId.toString());
        return new InContextRedirectMav(this.request, path);
    }

    private DatarouterUser getCurrentUser() {
        return this.datarouterUserService.getAndValidateCurrentUser(this.getSessionInfo().getRequiredSession());
    }

    private static List<String> roleToStrings(Collection<Role> roles) {
        return roles.stream().map(Role::getPersistentString).sorted(String.CASE_INSENSITIVE_ORDER).collect(Collectors.toList());
    }

    private String pathBuilder(String path, String param, String value) {
        return String.valueOf(path) + "?" + param + "=" + value;
    }

    private void checkEditPermission(DatarouterUser currentUser, DatarouterUser userToEdit, BiFunction<DatarouterUser, DatarouterUser, Boolean> permissionMethod) {
        Objects.requireNonNull(currentUser);
        Objects.requireNonNull(userToEdit);
        if (!permissionMethod.apply(currentUser, userToEdit).booleanValue()) {
            this.handleInvalidRequest();
        }
    }

    private String getSigninUrl() {
        String requestUrlWithoutContext = StringTool.getStringBeforeLastOccurrence((String)this.request.getRequestURI(), (String)this.request.getRequestURL().toString());
        return String.valueOf(requestUrlWithoutContext) + this.request.getContextPath() + this.paths.signin.toSlashedString();
    }

    private void handleInvalidRequest() {
        ResponseTool.sendError((HttpServletResponse)this.response, (int)403, (String)"invalid request");
    }

    private void addPaths(Mav mav) {
        mav.put("createUserSubmitPath", (Object)this.paths.admin.createUserSubmit.toSlashedString());
        mav.put("resetPasswordSubmitPath", (Object)this.paths.resetPasswordSubmit.toSlashedString());
        mav.put("resetPasswordPath", (Object)this.paths.resetPassword.toSlashedString());
        mav.put("editUserSubmitPath", (Object)this.paths.admin.editUserSubmit.toSlashedString());
    }

    public static class DatarouterUserListEntry {
        public final String id;
        public final String username;
        public final String token;
        public final boolean hasPermissionRequest;

        public DatarouterUserListEntry(String id, String username, String token, boolean hasPermissionRequest) {
            this.id = id;
            this.username = username;
            this.token = token;
            this.hasPermissionRequest = hasPermissionRequest;
        }
    }
}

