/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.service;

import io.datarouter.auth.service.UserDeprovisioningService;
import io.datarouter.auth.storage.deprovisioneduser.DeprovisionedUser;
import io.datarouter.auth.storage.deprovisioneduser.DeprovisionedUserDao;
import io.datarouter.auth.storage.deprovisioneduser.DeprovisionedUserKey;
import io.datarouter.auth.storage.user.DatarouterUserDao;
import io.datarouter.scanner.Scanner;
import io.datarouter.web.user.databean.DatarouterUser;
import io.datarouter.web.user.session.service.RoleManager;
import io.datarouter.web.user.session.service.UserSessionService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DatarouterUserDeprovisioningService
implements UserDeprovisioningService {
    @Inject
    private DatarouterUserDao datarouterUserDao;
    @Inject
    private DeprovisionedUserDao deprovisionedUserDao;
    @Inject
    private RoleManager roleManager;
    @Inject
    private UserDeprovisioningService.ShouldFlagUsersInsteadOfDeprovisioningSupplier shouldFlagUsersInsteadOfDeprovisioningSupplier;
    @Inject
    private UserSessionService userSessionService;

    @Override
    public List<String> flagUsersForDeprovisioning(List<String> usernames) {
        return this.doFlagOrDeprovision(usernames, false);
    }

    @Override
    public List<String> deprovisionUsers(List<String> usernames) {
        return this.doFlagOrDeprovision(usernames, true);
    }

    private List<String> doFlagOrDeprovision(List<String> usernames, boolean shouldDeprovision) {
        this.userSessionService.deleteUserSessions(usernames);
        ArrayList<DeprovisionedUser> deprovisionedUsers = new ArrayList<DeprovisionedUser>();
        List users = (List)Scanner.of(usernames).map(DatarouterUser.DatarouterUserByUsernameLookup::new).listTo(this.datarouterUserDao::getMultiByUsername);
        ArrayList<String> deprovisionedUsernames = new ArrayList<String>();
        users.forEach(user -> {
            deprovisionedUsers.add(new DeprovisionedUser(user.getUsername(), user.getRoles(), shouldDeprovision ? DeprovisionedUser.UserDeprovisioningStatus.DEPROVISIONED : DeprovisionedUser.UserDeprovisioningStatus.FLAGGED));
            user.setRoles(List.of());
            user.setEnabled(Boolean.valueOf(false));
            deprovisionedUsernames.add(user.getUsername());
        });
        this.deprovisionedUserDao.putMulti(deprovisionedUsers);
        if (shouldDeprovision) {
            this.datarouterUserDao.putMulti(users);
        }
        return deprovisionedUsernames;
    }

    @Override
    public List<String> restoreDeprovisionedUsers(List<String> usernames) {
        Set validRoles = this.roleManager.getAllRoles();
        Map deprovisionedRolesByUsername = (Map)((Scanner)Scanner.of(usernames).map(DeprovisionedUserKey::new).listTo(this.deprovisionedUserDao::scanWithPrefixes)).include(user -> user.getStatus() == DeprovisionedUser.UserDeprovisioningStatus.DEPROVISIONED).collect(Collectors.toMap(DeprovisionedUser::getUsername, DeprovisionedUser::getRoles));
        Map datarouterUserByUsername = ((List)Scanner.of(usernames).map(DatarouterUser.DatarouterUserByUsernameLookup::new).listTo(this.datarouterUserDao::getMultiByUsername)).stream().collect(Collectors.toMap(DatarouterUser::getUsername, Function.identity()));
        return (List)Scanner.of(usernames).include(deprovisionedRolesByUsername::containsKey).include(datarouterUserByUsername::containsKey).map(username -> {
            List rolesToRestore = ((Set)deprovisionedRolesByUsername.get(username)).stream().filter(validRoles::contains).collect(Collectors.toList());
            DatarouterUser datarouterUser = (DatarouterUser)datarouterUserByUsername.get(username);
            datarouterUser.setRoles(rolesToRestore);
            datarouterUser.setEnabled(Boolean.valueOf(true));
            return datarouterUser;
        }).flush(this.datarouterUserDao::putMulti).map(DatarouterUser::getUsername).flush(this.deprovisionedUserDao::deleteMultiUsernames).collect(Collectors.toList());
    }

    @Override
    public boolean shouldFlagUsersInsteadOfDeprovisioning() {
        return this.shouldFlagUsersInsteadOfDeprovisioningSupplier.get();
    }
}

