/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.service;

import io.datarouter.auth.cache.DatarouterAccountPermissionKeysByPrefixCache;
import io.datarouter.auth.service.DatarouterAccountLastUsedDateService;
import io.datarouter.auth.storage.account.BaseDatarouterAccountDao;
import io.datarouter.auth.storage.account.DatarouterAccount;
import io.datarouter.auth.storage.account.DatarouterAccountKey;
import io.datarouter.auth.storage.accountpermission.DatarouterAccountPermissionKey;
import io.datarouter.auth.storage.useraccountmap.BaseDatarouterUserAccountMapDao;
import io.datarouter.auth.storage.useraccountmap.DatarouterUserAccountMapKey;
import io.datarouter.model.databean.BaseDatabean;
import io.datarouter.scanner.Scanner;
import io.datarouter.web.user.databean.DatarouterUserKey;
import io.datarouter.web.util.http.RequestTool;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;

@Singleton
public class DatarouterAccountService {
    private final BaseDatarouterAccountDao datarouterAccountDao;
    private final BaseDatarouterUserAccountMapDao datarouterUserAccountMapDao;
    private final DatarouterAccountPermissionKeysByPrefixCache datarouterAccountPermissionKeysByPrefixCache;
    private final DatarouterAccountLastUsedDateService datarouterAccountLastUsedDateService;

    @Inject
    public DatarouterAccountService(BaseDatarouterAccountDao datarouterAccountDao, BaseDatarouterUserAccountMapDao datarouterUserAccountMapDao, DatarouterAccountPermissionKeysByPrefixCache datarouterAccountPermissionKeysByPrefixCache, DatarouterAccountLastUsedDateService datarouterAccountLastUsedDateService) {
        this.datarouterAccountDao = datarouterAccountDao;
        this.datarouterUserAccountMapDao = datarouterUserAccountMapDao;
        this.datarouterAccountPermissionKeysByPrefixCache = datarouterAccountPermissionKeysByPrefixCache;
        this.datarouterAccountLastUsedDateService = datarouterAccountLastUsedDateService;
    }

    public Optional<DatarouterAccount> getCurrentDatarouterAccount(HttpServletRequest request) {
        String apiKey = RequestTool.getParameterOrHeader((HttpServletRequest)request, (String)"apiKey");
        return Optional.ofNullable(apiKey).flatMap(this::findAccountForApiKey);
    }

    public Stream<DatarouterAccountPermissionKey> streamPermissionsForApiKey(String apiKey) {
        return this.findAccountForApiKey(apiKey).map(BaseDatabean::getKey).map(DatarouterAccountKey::getAccountName).map(DatarouterAccountPermissionKey::new).map(arg_0 -> ((DatarouterAccountPermissionKeysByPrefixCache)this.datarouterAccountPermissionKeysByPrefixCache).get(arg_0)).orElseGet(Optional::empty).map(Collection::stream).orElseGet(Stream::empty);
    }

    public Optional<DatarouterAccount> findAccountForApiKey(String apiKey) {
        Optional<DatarouterAccount> account = this.datarouterAccountDao.getFromAccountByApiKeyCache(apiKey);
        account.map(BaseDatabean::getKey).ifPresent(this.datarouterAccountLastUsedDateService::updateLastUsedDate);
        return account;
    }

    public boolean userCanAccessAccount(DatarouterUserKey userKey, String accountName) {
        DatarouterUserAccountMapKey key = new DatarouterUserAccountMapKey(userKey.getId(), accountName);
        return this.datarouterUserAccountMapDao.exists(key);
    }

    public boolean userCanAccessAccountAndUserMappingsEnabled(DatarouterUserKey userKey, String accountName) {
        DatarouterUserAccountMapKey key = new DatarouterUserAccountMapKey(userKey.getId(), accountName);
        boolean exists = this.datarouterUserAccountMapDao.exists(key);
        boolean userMappingEnabled = this.datarouterAccountDao.find(new DatarouterAccountKey(accountName)).map(DatarouterAccount::getEnableUserMappings).orElse(false);
        return exists && userMappingEnabled;
    }

    public Set<String> findAccountNamesForUser(DatarouterUserKey userKey) {
        return (Set)this.scanAccountKeysForUser(userKey).map(DatarouterAccountKey::getAccountName).collect(Collectors.toSet());
    }

    public Set<String> findAccountNamesForUserWithUserMappingsEnabled(DatarouterUserKey userKey) {
        return this.streamAccountForUserWithUserMappingEnabled(userKey).map(BaseDatabean::getKey).map(DatarouterAccountKey::getAccountName).collect(Collectors.toSet());
    }

    public List<DatarouterAccount> findAccountsForUser(DatarouterUserKey userKey) {
        return (List)this.scanAccountKeysForUser(userKey).listTo(this.datarouterAccountDao::getMulti);
    }

    private Scanner<DatarouterAccountKey> scanAccountKeysForUser(DatarouterUserKey userKey) {
        DatarouterUserAccountMapKey prefix = new DatarouterUserAccountMapKey(userKey.getId(), null);
        return this.datarouterUserAccountMapDao.scanKeysWithPrefix(prefix).map(DatarouterUserAccountMapKey::getDatarouterAccountKey);
    }

    public Stream<DatarouterAccount> streamAccountForUserWithUserMappingEnabled(DatarouterUserKey userKey) {
        DatarouterUserAccountMapKey prefix = new DatarouterUserAccountMapKey(userKey.getId(), null);
        return ((List)this.datarouterUserAccountMapDao.scanKeysWithPrefix(prefix).map(DatarouterUserAccountMapKey::getDatarouterAccountKey).listTo(this.datarouterAccountDao::getMulti)).stream().filter(DatarouterAccount::getEnableUserMappings);
    }

    public List<DatarouterAccount> getAccountsWithDuplicateApiKey() {
        Map accountsByApiKey = (Map)this.datarouterAccountDao.scan().collect(Collectors.groupingBy(DatarouterAccount::getApiKey));
        return accountsByApiKey.values().stream().filter(accounts -> accounts.size() > 1).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

