/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.service;

import io.datarouter.auth.service.DatarouterUserHistoryService;
import io.datarouter.auth.service.DatarouterUserService;
import io.datarouter.auth.storage.userhistory.DatarouterUserHistory;
import io.datarouter.httpclient.client.DatarouterService;
import io.datarouter.storage.config.DatarouterAdministratorEmailService;
import io.datarouter.util.BooleanTool;
import io.datarouter.web.user.authenticate.PermissionRequestAdditionalEmailsSupplier;
import io.datarouter.web.user.databean.DatarouterUser;
import io.datarouter.web.user.session.service.Role;
import io.datarouter.web.util.PasswordTool;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DatarouterUserEditService {
    private static final Logger logger = LoggerFactory.getLogger(DatarouterUserEditService.class);
    @Inject
    private DatarouterAdministratorEmailService adminEmailService;
    @Inject
    private DatarouterUserHistoryService userHistoryService;
    @Inject
    private DatarouterUserService datarouterUserService;
    @Inject
    private PermissionRequestAdditionalEmailsSupplier permissionRequestAdditionalEmails;
    @Inject
    private DatarouterService datarouterService;

    public void editUser(DatarouterUser user, DatarouterUser editor, String[] requestedRoles, Boolean enabled, String signinUrl, List<String> requestedAccounts, List<String> currentAccounts) {
        HashSet currentRoles;
        DatarouterUserHistory history = new DatarouterUserHistory(user.getId(), new Date(), editor.getId(), DatarouterUserHistory.DatarouterUserChangeType.EDIT, null);
        ArrayList<String> changes = new ArrayList<String>();
        Set<Role> allowedRoles = this.datarouterUserService.getAllowedUserRoles(editor, requestedRoles);
        if (!allowedRoles.equals(currentRoles = new HashSet(user.getRoles()))) {
            changes.add(DatarouterUserEditService.change("roles", currentRoles, allowedRoles));
            user.setRoles(allowedRoles);
        }
        if (!BooleanTool.nullSafeSame((Boolean)enabled, (Boolean)user.getEnabled())) {
            changes.add(DatarouterUserEditService.change("enabled", user.getEnabled(), enabled));
            user.setEnabled(enabled);
        }
        if (requestedAccounts.size() != 0) {
            String current = String.join((CharSequence)",", currentAccounts);
            String accountsAdded = String.join((CharSequence)",", requestedAccounts);
            changes.add(DatarouterUserEditService.change("accounts", current, accountsAdded));
        }
        if (changes.size() > 0) {
            history.setChanges(String.join((CharSequence)", ", changes));
            this.userHistoryService.recordRoleEdit(user, history, signinUrl);
        } else {
            logger.warn("User {} submitted edit request for user {}, but no changes were made.", (Object)editor.toString(), (Object)user.toString());
        }
    }

    public void changePassword(DatarouterUser user, DatarouterUser editor, String newPassword, String signinUrl) {
        DatarouterUserHistory history = new DatarouterUserHistory(user.getId(), new Date(), editor.getId(), DatarouterUserHistory.DatarouterUserChangeType.RESET, null);
        this.updateUserPassword(user, newPassword);
        history.setChanges("password");
        this.userHistoryService.recordPasswordChange(user, history, signinUrl);
    }

    private void updateUserPassword(DatarouterUser user, String password) {
        String passwordSalt = PasswordTool.generateSalt();
        String passwordDigest = PasswordTool.digest((String)passwordSalt, (String)password);
        user.setPasswordSalt(passwordSalt);
        user.setPasswordDigest(passwordDigest);
    }

    private static String change(String name, Object before, Object after) {
        return String.valueOf(name) + ": " + before + " => " + after;
    }

    public String getUserEditEmailRecipients(DatarouterUser ... users) {
        Set recipients = Arrays.stream(users).map(DatarouterUser::getUsername).collect(Collectors.toSet());
        ((Set)this.permissionRequestAdditionalEmails.get()).forEach(recipients::add);
        this.adminEmailService.getAdministratorEmailAddresses().forEach(recipients::add);
        return String.join((CharSequence)",", recipients);
    }

    public String getPermissionRequestEmailSubject(DatarouterUser user) {
        return String.format("Datarouter - Permission Request - %s - %s", this.datarouterService.getName(), user.getUsername());
    }
}

