/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.service;

import io.datarouter.auth.service.DefaultDatarouterAccountKeysSupplier;
import io.datarouter.auth.storage.account.BaseDatarouterAccountDao;
import io.datarouter.auth.storage.account.DatarouterAccount;
import io.datarouter.auth.storage.account.DatarouterAccountKey;
import io.datarouter.auth.storage.accountpermission.BaseDatarouterAccountPermissionDao;
import io.datarouter.auth.storage.accountpermission.DatarouterAccountPermission;
import io.datarouter.auth.storage.useraccountmap.BaseDatarouterUserAccountMapDao;
import io.datarouter.auth.storage.useraccountmap.DatarouterUserAccountMap;
import io.datarouter.storage.config.DatarouterProperties;
import io.datarouter.storage.servertype.ServerType;
import io.datarouter.util.lang.ObjectTool;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DatarouterAccountCreationService {
    private static final Logger logger = LoggerFactory.getLogger(DatarouterAccountCreationService.class);
    public static final String DEFAULT_ACCOUNT_NAME = "default";
    public static final String DEFAULT_ACCOUNT_CREATOR = "defaultCreator";
    @Inject
    private BaseDatarouterAccountDao datarouterAccountDao;
    @Inject
    private BaseDatarouterUserAccountMapDao userAccountMapDao;
    @Inject
    private BaseDatarouterAccountPermissionDao accountPermissionDao;
    @Inject
    private DatarouterProperties datarouterProperties;
    @Inject
    private DefaultDatarouterAccountKeysSupplier defaultDatarouterAccountKeys;

    public void createDefaultAccountAndMapToDefaultAdminUser() {
        if (ObjectTool.notEquals((Object)this.datarouterProperties.getServerTypeString(), (Object)ServerType.DEV.getPersistentString())) {
            return;
        }
        if (this.datarouterAccountDao.exists(new DatarouterAccountKey(DEFAULT_ACCOUNT_NAME))) {
            return;
        }
        DatarouterAccount account = new DatarouterAccount(DEFAULT_ACCOUNT_NAME, new Date(), DEFAULT_ACCOUNT_CREATOR);
        account.setEnableUserMappings(true);
        account.resetApiKeyToDefault(this.defaultDatarouterAccountKeys.getDefaultApiKey());
        account.resetSecretKeyToDefault(this.defaultDatarouterAccountKeys.getDefaultSecretKey());
        this.datarouterAccountDao.put(account);
        logger.warn("Created default DatarouterAccount");
        this.userAccountMapDao.put(new DatarouterUserAccountMap(1L, DEFAULT_ACCOUNT_NAME));
        logger.warn("Mapped the default admin user to the default account");
    }

    public void createDefaultAccountPermission() {
        if (ObjectTool.notEquals((Object)this.datarouterProperties.getServerTypeString(), (Object)ServerType.DEV.getPersistentString())) {
            return;
        }
        this.accountPermissionDao.put(new DatarouterAccountPermission(DEFAULT_ACCOUNT_NAME, "all"));
        logger.warn("Created default DatarouterAccountPermission");
    }
}

