/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.storage.user;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.key.unique.UniqueKey;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.Datarouter;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.dao.BaseDao;
import io.datarouter.storage.dao.BaseDaoParams;
import io.datarouter.storage.node.factory.NodeFactory;
import io.datarouter.storage.node.op.combo.IndexedSortedMapStorage;
import io.datarouter.util.tuple.Range;
import io.datarouter.web.user.databean.DatarouterUser;
import io.datarouter.web.user.databean.DatarouterUserKey;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DatarouterUserDao
extends BaseDao {
    private final IndexedSortedMapStorage<DatarouterUserKey, DatarouterUser> node;

    @Inject
    public DatarouterUserDao(Datarouter datarouter, NodeFactory nodeFactory, DatarouterUserDaoParams params) {
        super(datarouter);
        this.node = (IndexedSortedMapStorage)nodeFactory.create(params.clientId, DatarouterUser::new, DatarouterUser.DatarouterUserFielder::new).buildAndRegister();
    }

    public DatarouterUser get(DatarouterUserKey key) {
        return (DatarouterUser)this.node.get((PrimaryKey)key);
    }

    public DatarouterUser getByUserToken(DatarouterUser.DatarouterUserByUserTokenLookup key) {
        return (DatarouterUser)this.node.lookupUnique((UniqueKey)key);
    }

    public DatarouterUser getByUsername(DatarouterUser.DatarouterUserByUsernameLookup key) {
        return (DatarouterUser)this.node.lookupUnique((UniqueKey)key);
    }

    public List<DatarouterUser> getMulti(Collection<DatarouterUserKey> keys) {
        return this.node.getMulti(keys);
    }

    public List<DatarouterUser> getMultiByUserTokens(Collection<DatarouterUser.DatarouterUserByUserTokenLookup> keys) {
        return this.node.lookupMultiUnique(keys);
    }

    public List<DatarouterUser> getMultiByUsername(Collection<DatarouterUser.DatarouterUserByUsernameLookup> keys) {
        return this.node.lookupMultiUnique(keys);
    }

    public Optional<DatarouterUser> find(DatarouterUserKey key) {
        return this.node.find((PrimaryKey)key);
    }

    public Optional<DatarouterUser> find(DatarouterUser.DatarouterUserByUserTokenLookup key) {
        return Optional.ofNullable((DatarouterUser)this.node.lookupUnique((UniqueKey)key));
    }

    public Scanner<DatarouterUser> scan() {
        return this.node.scan();
    }

    public void put(DatarouterUser databean) {
        this.node.put((Databean)databean);
    }

    public void putMulti(Collection<DatarouterUser> databeans) {
        this.node.putMulti(databeans);
    }

    public void delete(DatarouterUserKey key) {
        this.node.delete((PrimaryKey)key);
    }

    public void deleteMulti(Collection<DatarouterUserKey> keys) {
        this.node.deleteMulti(keys);
    }

    public long count() {
        return this.node.count(Range.everything());
    }

    public boolean exists(DatarouterUser.DatarouterUserByUserTokenLookup key) {
        return this.node.lookupUnique((UniqueKey)key) != null;
    }

    public static class DatarouterUserDaoParams
    extends BaseDaoParams {
        public DatarouterUserDaoParams(ClientId clientId) {
            super(clientId);
        }
    }
}

