/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.service;

import io.datarouter.auth.service.DatarouterUserInfo;
import io.datarouter.util.BooleanTool;
import io.datarouter.web.user.databean.DatarouterUser;
import io.datarouter.web.user.session.CurrentUserSessionInfo;
import io.datarouter.web.user.session.DatarouterSession;
import io.datarouter.web.user.session.DatarouterSessionManager;
import io.datarouter.web.user.session.service.Role;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.ServletRequest;

@Singleton
public class DatarouterCurrentUserSessionInfo
implements CurrentUserSessionInfo {
    @Inject
    private DatarouterUserInfo datarouterUserInfo;

    public Optional<DatarouterUser> getUser(ServletRequest request) {
        return DatarouterSessionManager.getFromRequest((ServletRequest)request).map(DatarouterSession::getUserId).flatMap(this.datarouterUserInfo::getUserById).map(DatarouterCurrentUserSessionInfo::validateEnabled);
    }

    public Optional<DatarouterSession> getSession(ServletRequest request) {
        return DatarouterSessionManager.getFromRequest((ServletRequest)request);
    }

    public Set<Role> getRoles(ServletRequest request) {
        return this.getSession(request).map(DatarouterSession::getRoles).map(HashSet::new).orElseGet(HashSet::new);
    }

    private static DatarouterUser validateEnabled(DatarouterUser user) {
        if (!BooleanTool.isTrue((Boolean)user.getEnabled())) {
            throw new RuntimeException("Current user is not enabled");
        }
        return user;
    }
}

