/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.config;

import io.datarouter.auth.config.DatarouterAccountConfigAppListener;
import io.datarouter.auth.config.DatarouterAuthPaths;
import io.datarouter.auth.config.DatarouterAuthRouteSet;
import io.datarouter.auth.config.DatarouterAuthSettingRoot;
import io.datarouter.auth.config.DatarouterAuthTriggerGroup;
import io.datarouter.auth.config.DatarouterUserConfigAppListener;
import io.datarouter.auth.service.DatarouterUserInfo;
import io.datarouter.auth.service.DefaultDatarouterAccountKeys;
import io.datarouter.auth.service.DefaultDatarouterAccountKeysSupplier;
import io.datarouter.auth.service.DefaultDatarouterUserPassword;
import io.datarouter.auth.service.DefaultDatarouterUserPasswordSupplier;
import io.datarouter.auth.service.UserInfo;
import io.datarouter.auth.storage.account.BaseDatarouterAccountDao;
import io.datarouter.auth.storage.account.DatarouterAccountDao;
import io.datarouter.auth.storage.accountpermission.BaseDatarouterAccountPermissionDao;
import io.datarouter.auth.storage.accountpermission.DatarouterAccountPermissionDao;
import io.datarouter.auth.storage.permissionrequest.DatarouterPermissionRequestDao;
import io.datarouter.auth.storage.user.DatarouterUserDao;
import io.datarouter.auth.storage.useraccountmap.BaseDatarouterUserAccountMapDao;
import io.datarouter.auth.storage.useraccountmap.DatarouterUserAccountMapDao;
import io.datarouter.auth.storage.userhistory.DatarouterUserHistoryDao;
import io.datarouter.auth.web.DatarouterDocumentationRouteSet;
import io.datarouter.httpclient.path.PathNode;
import io.datarouter.job.config.BaseJobPlugin;
import io.datarouter.job.config.DatarouterJobRouteSet;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.dao.Dao;
import io.datarouter.storage.dao.DaosModuleBuilder;
import io.datarouter.web.navigation.AppNavBarCategory;
import io.datarouter.web.navigation.NavBarCategory;
import io.datarouter.web.navigation.NavBarItem;
import io.datarouter.web.user.BaseDatarouterSessionDao;
import io.datarouter.web.user.DatarouterSessionDao;
import io.datarouter.web.user.authenticate.saml.BaseDatarouterSamlDao;
import io.datarouter.web.user.authenticate.saml.DatarouterSamlDao;
import java.util.List;

public class DatarouterAuthPlugin
extends BaseJobPlugin {
    private final Class<? extends UserInfo> userInfoClass;
    private final String defaultDatarouterUserPassword;
    private final String defaultApiKey;
    private final String defaultSecretKey;

    private DatarouterAuthPlugin(boolean enableUserAuth, DatarouterAuthDaoModule daosModuleBuilder, Class<? extends UserInfo> userInfoClass, String defaultDatarouterUserPassword, String defaultApiKey, String defaultSecretKey) {
        this.addUnorderedAppListener(DatarouterAccountConfigAppListener.class);
        this.addUnorderedAppListener(DatarouterUserConfigAppListener.class);
        DatarouterAuthPaths paths = new DatarouterAuthPaths();
        this.addAppNavBarItem(new NavBarItem((NavBarCategory)AppNavBarCategory.ADMIN, paths.admin.accounts, "Account Manager"));
        if (enableUserAuth) {
            this.addOrderedRouteSet(DatarouterAuthRouteSet.class, DatarouterJobRouteSet.class);
            this.addAppNavBarItem(new NavBarItem((NavBarCategory)AppNavBarCategory.ADMIN, paths.admin.viewUsers, "View Users"));
            this.addAppNavBarItem(new NavBarItem((NavBarCategory)AppNavBarCategory.USER, paths.admin.editUser, "Edit User"));
            this.addAppNavBarItem(new NavBarItem((NavBarCategory)AppNavBarCategory.USER, (PathNode)paths.permissionRequest, "Permission Request"));
            this.addAppNavBarItem(new NavBarItem((NavBarCategory)AppNavBarCategory.USER, paths.resetPassword, "Reset Password"));
            this.addAppNavBarItem(new NavBarItem((NavBarCategory)AppNavBarCategory.USER, paths.admin.createUser, "Create User"));
        }
        this.addAppNavBarItem(new NavBarItem((NavBarCategory)AppNavBarCategory.DOCS, paths.docs.toSlashedStringWithTrailingSlash(), "Docs"));
        this.addUnorderedRouteSet(DatarouterDocumentationRouteSet.class);
        this.addSettingRoot(DatarouterAuthSettingRoot.class);
        this.addTriggerGroup(DatarouterAuthTriggerGroup.class);
        this.setDaosModuleBuilder(daosModuleBuilder);
        this.userInfoClass = userInfoClass;
        this.defaultDatarouterUserPassword = defaultDatarouterUserPassword;
        this.defaultApiKey = defaultApiKey;
        this.defaultSecretKey = defaultSecretKey;
    }

    public String getName() {
        return "DatarouterAuth";
    }

    protected void configure() {
        this.bindActual(BaseDatarouterSessionDao.class, DatarouterSessionDao.class);
        this.bindActual(BaseDatarouterAccountDao.class, DatarouterAccountDao.class);
        this.bindActual(BaseDatarouterAccountPermissionDao.class, DatarouterAccountPermissionDao.class);
        this.bindActual(BaseDatarouterUserAccountMapDao.class, DatarouterUserAccountMapDao.class);
        this.bindActual(BaseDatarouterSamlDao.class, DatarouterSamlDao.class);
        this.bind(UserInfo.class).to(this.userInfoClass);
        this.bindActualInstance(DefaultDatarouterUserPasswordSupplier.class, new DefaultDatarouterUserPassword(this.defaultDatarouterUserPassword));
        this.bindActualInstance(DefaultDatarouterAccountKeysSupplier.class, new DefaultDatarouterAccountKeys(this.defaultApiKey, this.defaultSecretKey));
    }

    public static class DatarouterAuthDaoModule
    extends DaosModuleBuilder {
        private final ClientId datarouterAccountClientId;
        private final ClientId datarouterAccountPermissionClientId;
        private final ClientId datarouterPermissionRequestClientId;
        private final ClientId datarouterSamlClientId;
        private final ClientId datarouterUserAccountMapClientId;
        private final ClientId datarouterUserClientId;
        private final ClientId datarouterUserHistoryClientId;

        public DatarouterAuthDaoModule(ClientId datarouterAccountClientId, ClientId datarouterAccountPermissionClientId, ClientId datarouterPermissionRequestClientId, ClientId datarouterSamlClientId, ClientId datarouterUserAccountMapClientId, ClientId datarouterUserClientId, ClientId datarouterUserHistoryClientId) {
            this.datarouterAccountClientId = datarouterAccountClientId;
            this.datarouterAccountPermissionClientId = datarouterAccountPermissionClientId;
            this.datarouterPermissionRequestClientId = datarouterPermissionRequestClientId;
            this.datarouterSamlClientId = datarouterSamlClientId;
            this.datarouterUserAccountMapClientId = datarouterUserAccountMapClientId;
            this.datarouterUserClientId = datarouterUserClientId;
            this.datarouterUserHistoryClientId = datarouterUserHistoryClientId;
        }

        public List<Class<? extends Dao>> getDaoClasses() {
            return List.of(DatarouterAccountDao.class, DatarouterAccountPermissionDao.class, DatarouterPermissionRequestDao.class, DatarouterUserAccountMapDao.class, DatarouterUserDao.class, DatarouterUserHistoryDao.class, DatarouterSamlDao.class);
        }

        public void configure() {
            this.bind(DatarouterUserDao.DatarouterUserDaoParams.class).toInstance((Object)new DatarouterUserDao.DatarouterUserDaoParams(this.datarouterUserClientId));
            this.bind(DatarouterUserHistoryDao.DatarouterUserHistoryDaoParams.class).toInstance((Object)new DatarouterUserHistoryDao.DatarouterUserHistoryDaoParams(this.datarouterUserHistoryClientId));
            this.bind(DatarouterPermissionRequestDao.DatarouterPermissionRequestDaoParams.class).toInstance((Object)new DatarouterPermissionRequestDao.DatarouterPermissionRequestDaoParams(this.datarouterPermissionRequestClientId));
            this.bind(DatarouterAccountDao.DatarouterAccountDaoParams.class).toInstance((Object)new DatarouterAccountDao.DatarouterAccountDaoParams(this.datarouterAccountClientId));
            this.bind(DatarouterAccountPermissionDao.DatarouterAccountPermissionDaoParams.class).toInstance((Object)new DatarouterAccountPermissionDao.DatarouterAccountPermissionDaoParams(this.datarouterAccountPermissionClientId));
            this.bind(DatarouterUserAccountMapDao.DatarouterUserAccountMapDaoParams.class).toInstance((Object)new DatarouterUserAccountMapDao.DatarouterUserAccountMapDaoParams(this.datarouterUserAccountMapClientId));
            this.bind(DatarouterSamlDao.DatarouterSamlDaoParams.class).toInstance((Object)new DatarouterSamlDao.DatarouterSamlDaoParams(this.datarouterSamlClientId));
        }
    }

    public static class DatarouterAuthPluginBuilder {
        private final boolean enableUserAuth;
        private final ClientId defaultClientId;
        private DatarouterAuthDaoModule daoModule;
        private Class<? extends UserInfo> userInfoClass = DatarouterUserInfo.class;
        private String defaultDatarouterUserPassword = "";
        private String defaultApiKey = "";
        private String defaultSecretKey = "";

        public DatarouterAuthPluginBuilder(boolean enableUserAuth, ClientId defaultClientId, String defaultDatarouterUserPassword, String defaultApiKey, String defaultSecretKey) {
            this.enableUserAuth = enableUserAuth;
            this.defaultClientId = defaultClientId;
            this.defaultDatarouterUserPassword = defaultDatarouterUserPassword;
            this.defaultApiKey = defaultApiKey;
            this.defaultSecretKey = defaultSecretKey;
        }

        public DatarouterAuthPluginBuilder setDaoModule(DatarouterAuthDaoModule daoModule) {
            this.daoModule = daoModule;
            return this;
        }

        public DatarouterAuthPluginBuilder setUserInfoClass(Class<? extends UserInfo> userInfoClass) {
            this.userInfoClass = userInfoClass;
            return this;
        }

        public DatarouterAuthPlugin build() {
            return new DatarouterAuthPlugin(this.enableUserAuth, this.daoModule == null ? new DatarouterAuthDaoModule(this.defaultClientId, this.defaultClientId, this.defaultClientId, this.defaultClientId, this.defaultClientId, this.defaultClientId, this.defaultClientId) : this.daoModule, this.userInfoClass, this.defaultDatarouterUserPassword, this.defaultApiKey, this.defaultSecretKey);
        }
    }
}

