/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.storage.roleapprovals;

import io.datarouter.auth.storage.roleapprovals.DatarouterUserRoleApproval;
import io.datarouter.auth.storage.roleapprovals.DatarouterUserRoleApprovalKey;
import io.datarouter.auth.storage.userhistory.DatarouterUserHistoryDao;
import io.datarouter.model.databean.BaseDatabean;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.Datarouter;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.dao.BaseDao;
import io.datarouter.storage.dao.BaseRedundantDaoParams;
import io.datarouter.storage.node.factory.NodeFactory;
import io.datarouter.storage.node.op.combo.SortedMapStorage;
import io.datarouter.storage.tag.Tag;
import io.datarouter.virtualnode.redundant.RedundantSortedMapStorageNode;
import io.datarouter.web.user.databean.DatarouterUser;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DatarouterUserRoleApprovalDao
extends BaseDao {
    private static final Logger logger = LoggerFactory.getLogger(DatarouterUserRoleApprovalDao.class);
    private final SortedMapStorage.SortedMapStorageNode<DatarouterUserRoleApprovalKey, DatarouterUserRoleApproval, DatarouterUserRoleApproval.DatarouterUserRoleApprovalFielder> node;

    @Inject
    public DatarouterUserRoleApprovalDao(Datarouter datarouter, NodeFactory nodeFactory, DatarouterUserHistoryDao.DatarouterUserHistoryDaoParams params) {
        super(datarouter);
        this.node = (SortedMapStorage.SortedMapStorageNode)Scanner.of((Iterable)params.clientIds).map(clientId -> {
            SortedMapStorage.SortedMapStorageNode node = (SortedMapStorage.SortedMapStorageNode)nodeFactory.create(clientId, DatarouterUserRoleApproval::new, DatarouterUserRoleApproval.DatarouterUserRoleApprovalFielder::new).withTag(Tag.DATAROUTER).build();
            return node;
        }).listTo(RedundantSortedMapStorageNode::makeIfMulti);
        datarouter.register(this.node);
    }

    public void put(DatarouterUserRoleApproval databean) {
        this.node.put((Databean)databean);
    }

    public DatarouterUserRoleApproval get(DatarouterUserRoleApprovalKey key) {
        return (DatarouterUserRoleApproval)this.node.get((PrimaryKey)key);
    }

    public List<DatarouterUserRoleApproval> getAllForUser(DatarouterUser user) {
        return this.node.scanWithPrefix((PrimaryKey)new DatarouterUserRoleApprovalKey(user.getUsername(), null, null, null)).list();
    }

    public List<DatarouterUserRoleApproval> getAllOutstandingApprovalsForUser(DatarouterUser user) {
        return Scanner.of(this.getAllForUser(user)).include(roleApproval -> roleApproval.getAllApprovalRequirementsMetAt() == null).list();
    }

    public void setAllRequirementsMetAtForUserRole(DatarouterUser user, String role) {
        Instant allRequirementsMetAt = Instant.now();
        this.node.scanWithPrefix((PrimaryKey)new DatarouterUserRoleApprovalKey(user.getUsername(), role, null, null)).map(databean -> {
            if (databean.getAllApprovalRequirementsMetAt() != null) {
                return databean;
            }
            return databean.withAllApprovalRequirementsMetAt(allRequirementsMetAt);
        }).flush(arg_0 -> this.node.putMulti(arg_0));
    }

    public void deleteOutstandingApprovals(DatarouterUser user, String role, DatarouterUser editor) {
        this.node.scanWithPrefix((PrimaryKey)new DatarouterUserRoleApprovalKey(user.getUsername(), role, editor.getUsername(), null)).include(databean -> databean.getAllApprovalRequirementsMetAt() == null).map(BaseDatabean::getKey).flush(arg_0 -> this.node.deleteMulti(arg_0));
    }

    public void deleteOutstandingApprovalsOfApprovalTypeForRole(String role, String approvalType) {
        Objects.requireNonNull(role);
        Objects.requireNonNull(approvalType);
        logger.warn("Deleting outstanding role approvals for role={} and approvalType={}", (Object)role, (Object)approvalType);
        this.node.scan().include(databean -> databean.getAllApprovalRequirementsMetAt() == null && role.equals(((DatarouterUserRoleApprovalKey)databean.getKey()).getRequestedRole()) && approvalType.equals(databean.getApprovalType())).map(BaseDatabean::getKey).flush(arg_0 -> this.node.deleteMulti(arg_0));
    }

    public static class DatarouterUserRoleApprovalDaoParams
    extends BaseRedundantDaoParams {
        public DatarouterUserRoleApprovalDaoParams(List<ClientId> clientIds) {
            super(clientIds);
        }
    }
}

