/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.storage.account;

import io.datarouter.auth.storage.account.BaseDatarouterAccountCredentialDao;
import io.datarouter.auth.storage.account.DatarouterAccountCredential;
import io.datarouter.auth.storage.account.DatarouterAccountCredentialByAccountNameKey;
import io.datarouter.auth.storage.account.DatarouterAccountCredentialKey;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.databean.FieldlessIndexEntry;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.Datarouter;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.config.PutMethod;
import io.datarouter.storage.dao.BaseDao;
import io.datarouter.storage.dao.BaseRedundantDaoParams;
import io.datarouter.storage.node.builder.NodeBuilder;
import io.datarouter.storage.node.factory.IndexingNodeFactory;
import io.datarouter.storage.node.factory.NodeFactory;
import io.datarouter.storage.node.op.combo.IndexedSortedMapStorage;
import io.datarouter.storage.node.op.index.UniqueIndexReader;
import io.datarouter.storage.tag.Tag;
import io.datarouter.util.Require;
import io.datarouter.util.string.StringTool;
import io.datarouter.virtualnode.redundant.RedundantIndexedSortedMapStorageNode;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

@Singleton
public class DatarouterAccountCredentialDao
extends BaseDao
implements BaseDatarouterAccountCredentialDao {
    private final IndexedSortedMapStorage.IndexedSortedMapStorageNode<DatarouterAccountCredentialKey, DatarouterAccountCredential, DatarouterAccountCredential.DatarouterAccountCredentialFielder> node;
    private final UniqueIndexReader<DatarouterAccountCredentialKey, DatarouterAccountCredential, DatarouterAccountCredentialByAccountNameKey, FieldlessIndexEntry<DatarouterAccountCredentialByAccountNameKey, DatarouterAccountCredentialKey, DatarouterAccountCredential>> byAccountName;

    @Inject
    public DatarouterAccountCredentialDao(Datarouter datarouter, NodeFactory nodeFactory, IndexingNodeFactory indexingNodeFactory, DatarouterAccountCredentialDaoParams params) {
        super(datarouter);
        this.node = (IndexedSortedMapStorage.IndexedSortedMapStorageNode)Scanner.of((Iterable)params.clientIds).map(clientId -> {
            NodeBuilder builder = nodeFactory.create(clientId, DatarouterAccountCredential::new, DatarouterAccountCredential.DatarouterAccountCredentialFielder::new).withTag(Tag.DATAROUTER);
            datarouterAccountCredentialDaoParams.tableName.ifPresent(arg_0 -> ((NodeBuilder)builder).withTableName(arg_0));
            IndexedSortedMapStorage.IndexedSortedMapStorageNode node = (IndexedSortedMapStorage.IndexedSortedMapStorageNode)builder.build();
            return node;
        }).listTo(RedundantIndexedSortedMapStorageNode::makeIfMulti);
        this.byAccountName = indexingNodeFactory.createKeyOnlyManagedIndex(DatarouterAccountCredentialByAccountNameKey::new, this.node).build();
        datarouter.register(this.node);
    }

    @Override
    public void put(DatarouterAccountCredential databean) {
        this.node.put((Databean)databean);
    }

    @Override
    public void insertOrBust(DatarouterAccountCredential databean) {
        this.node.put((Databean)databean, new Config().setPutMethod(PutMethod.INSERT_OR_BUST));
    }

    @Override
    public void updateIgnore(DatarouterAccountCredential databean) {
        this.node.put((Databean)databean, new Config().setPutMethod(PutMethod.UPDATE_IGNORE));
    }

    @Override
    public void updateMultiIgnore(Collection<DatarouterAccountCredential> databeans) {
        this.node.putMulti(databeans, new Config().setPutMethod(PutMethod.UPDATE_IGNORE));
    }

    @Override
    public DatarouterAccountCredential get(DatarouterAccountCredentialKey key) {
        return (DatarouterAccountCredential)this.node.get((PrimaryKey)key);
    }

    @Override
    public Scanner<DatarouterAccountCredential> scan() {
        return this.node.scan();
    }

    @Override
    public Scanner<DatarouterAccountCredential> scanMulti(Collection<DatarouterAccountCredentialKey> keys) {
        return this.node.scanMulti(keys);
    }

    @Override
    public Scanner<DatarouterAccountCredentialKey> scanKeys() {
        return this.node.scanKeys();
    }

    @Override
    public Scanner<DatarouterAccountCredential> scanByAccountNames(Collection<String> accountNames) {
        return (Scanner)Scanner.of(accountNames).map(accountName -> new DatarouterAccountCredentialByAccountNameKey((String)accountName, null)).listTo(arg_0 -> this.byAccountName.scanDatabeansWithPrefixes(arg_0));
    }

    public Scanner<DatarouterAccountCredential> scanByAccountName(String accountName) {
        DatarouterAccountCredentialByAccountNameKey prefix = new DatarouterAccountCredentialByAccountNameKey(accountName, null);
        return this.byAccountName.scanDatabeansWithPrefix((PrimaryKey)prefix);
    }

    @Override
    public boolean exists(DatarouterAccountCredentialKey key) {
        return this.node.exists((PrimaryKey)key);
    }

    @Override
    public boolean exists(String accountName) {
        return this.byAccountName.scanKeysWithPrefix((PrimaryKey)new DatarouterAccountCredentialByAccountNameKey(accountName, null)).findFirst().isPresent();
    }

    @Override
    public void delete(DatarouterAccountCredentialKey key) {
        this.node.delete((PrimaryKey)key);
    }

    @Override
    public void deleteByAccountName(String accountName) {
        this.byAccountName.scanKeysWithPrefix((PrimaryKey)new DatarouterAccountCredentialByAccountNameKey(accountName, null)).map(DatarouterAccountCredentialByAccountNameKey::getTargetKey).flush(arg_0 -> this.node.deleteMulti(arg_0));
    }

    @Override
    public Optional<DatarouterAccountCredential> find(DatarouterAccountCredentialKey key) {
        return this.node.find((PrimaryKey)key);
    }

    public static class DatarouterAccountCredentialDaoParams
    extends BaseRedundantDaoParams {
        public final Optional<String> tableName;

        public DatarouterAccountCredentialDaoParams(List<ClientId> clientIds) {
            super(clientIds);
            this.tableName = Optional.empty();
        }

        public DatarouterAccountCredentialDaoParams(List<ClientId> clientIds, String tableName) {
            super(clientIds);
            Require.isTrue((boolean)StringTool.notNullNorEmpty((String)tableName));
            this.tableName = Optional.of(tableName);
        }
    }
}

