/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.service;

import io.datarouter.auth.config.DatarouterAuthSettingRoot;
import io.datarouter.auth.service.CallerTypeByAccountNameCache;
import io.datarouter.httpclient.endpoint.caller.CallerType;
import io.datarouter.httpclient.endpoint.java.BaseEndpoint;
import io.datarouter.util.lang.ReflectionTool;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.validator.HandlerAccountCallerValidator;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultHandlerAccountCallerValidator
implements HandlerAccountCallerValidator {
    private static final Logger logger = LoggerFactory.getLogger(DefaultHandlerAccountCallerValidator.class);
    private static final Set<String> logs = ConcurrentHashMap.newKeySet();
    @Inject
    private CallerTypeByAccountNameCache callerTypeByAccountNameCache;
    @Inject
    private DatarouterAuthSettingRoot settings;

    public void validate(String accountName, BaseEndpoint<?, ?> endpoint) {
        if (!((Boolean)this.settings.enableHandlerAccountCallerValidator.get()).booleanValue()) {
            return;
        }
        try {
            String message;
            String accountCallerType = this.callerTypeByAccountNameCache.get(accountName);
            Class endpointCallerTypeClass = endpoint.callerType;
            String endpointCallerType = ((CallerType)ReflectionTool.create((Class)endpointCallerTypeClass)).getName();
            if ((accountCallerType == null || !accountCallerType.equals(endpointCallerType)) && logs.add(message = String.format("EndpointName=%s accountName=%s accountCallerType=%s endpointCallerType=%s", endpoint.getClass().getSimpleName(), accountName, accountCallerType, endpointCallerType))) {
                logger.info(message);
            }
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
        }
    }

    public void validate(String accountName, Method method) {
        if (!((Boolean)this.settings.enableHandlerAccountCallerValidator.get()).booleanValue()) {
            return;
        }
        try {
            String message;
            String accountCallerType = this.callerTypeByAccountNameCache.get(accountName);
            Class handlerCallerTypeClass = method.getAnnotation(BaseHandler.Handler.class).callerType();
            String handlerCallerType = ((CallerType)ReflectionTool.create((Class)handlerCallerTypeClass)).getName();
            if ((accountCallerType == null || !accountCallerType.equals(handlerCallerType)) && logs.add(message = String.format("HandlerClass=%s accountName=%s accountCallerType=%s endpointCallerType=%s", String.valueOf(method.getDeclaringClass().getName()) + "." + method.getName(), accountName, accountCallerType, handlerCallerType))) {
                logger.info(message);
            }
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
        }
    }
}

