/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.service;

import io.datarouter.auth.model.dto.RoleApprovalRequirementStatus;
import io.datarouter.auth.model.dto.UserRoleMetadata;
import io.datarouter.auth.storage.roleapprovals.DatarouterUserRoleApprovalDao;
import io.datarouter.auth.storage.roleapprovals.DatarouterUserRoleApprovalKey;
import io.datarouter.auth.storage.user.DatarouterUserDao;
import io.datarouter.scanner.Scanner;
import io.datarouter.web.user.databean.DatarouterUser;
import io.datarouter.web.user.databean.DatarouterUserKey;
import io.datarouter.web.user.role.DatarouterUserRole;
import io.datarouter.web.user.role.Role;
import io.datarouter.web.user.role.RoleApprovalType;
import io.datarouter.web.user.role.RoleManager;
import io.datarouter.web.user.session.service.Session;
import io.datarouter.web.util.PasswordTool;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

@Singleton
public class DatarouterUserService {
    @Inject
    private DatarouterUserDao nodes;
    @Inject
    private RoleManager roleManager;
    @Inject
    private DatarouterUserRoleApprovalDao roleApprovalDao;

    public DatarouterUser getAndValidateCurrentUser(Session session) {
        DatarouterUser user = this.getUserBySession(session);
        if (user == null || !user.getEnabled().booleanValue()) {
            throw new RuntimeException("Current user does not exist or is not enabled.");
        }
        return user;
    }

    public DatarouterUser getUserBySession(Session session) {
        if (session == null || session.getUserId() == null) {
            return null;
        }
        return this.nodes.get(new DatarouterUserKey(session.getUserId()));
    }

    public DatarouterUser getUserById(Long id) {
        return this.nodes.get(new DatarouterUserKey(id));
    }

    public boolean canEditUserPassword(DatarouterUser editor, DatarouterUser user) {
        return user.equals((Object)editor) || !this.isDatarouterAdmin(user) && this.isDatarouterAdmin(editor) && editor.getEnabled() != false;
    }

    public boolean canEditUser(DatarouterUser editor, DatarouterUser user) {
        return user.equals((Object)editor) || this.isDatarouterAdmin(editor) && editor.getEnabled() != false;
    }

    public boolean canHavePassword(DatarouterUser user) {
        return user.getPasswordDigest() != null || this.isDatarouterAdmin(user);
    }

    public boolean isPasswordCorrect(DatarouterUser user, String rawPassword) {
        if (user == null || rawPassword == null) {
            return false;
        }
        String passwordDigest = PasswordTool.digest((String)user.getPasswordSalt(), (String)rawPassword);
        return Objects.equals(user.getPasswordDigest(), passwordDigest);
    }

    public void assertUserDoesNotExist(Long id, String userToken, String username) {
        DatarouterUser userWithId = this.getUserById(id);
        if (userWithId != null) {
            throw new IllegalArgumentException("DatarouterUser already exists with id=" + id);
        }
        DatarouterUser userWithUserToken = this.nodes.getByUserToken(new DatarouterUser.DatarouterUserByUserTokenLookup(userToken));
        if (userWithUserToken != null) {
            throw new IllegalArgumentException("DatarouterUser already exists with userToken=" + userToken);
        }
        DatarouterUser userWithEmail = this.nodes.getByUsername(new DatarouterUser.DatarouterUserByUsernameLookup(username));
        if (userWithEmail != null) {
            throw new IllegalArgumentException("DatarouterUser already exists with username=" + username);
        }
    }

    public boolean isDatarouterAdmin(DatarouterUser user) {
        return user.getRoles().contains(DatarouterUserRole.DATAROUTER_ADMIN.getRole());
    }

    public Map<Role, Map<RoleApprovalType, Set<String>>> getCurrentRoleApprovals(DatarouterUser user) {
        return (Map)Scanner.of(this.roleApprovalDao.getAllOutstandingApprovalsForUser(user)).exclude(roleApproval -> this.roleManager.findRoleFromPersistentString(((DatarouterUserRoleApprovalKey)roleApproval.getKey()).getRequestedRole()).isEmpty()).exclude(roleApproval -> this.roleManager.findRoleApprovalTypeFromPersistentString(roleApproval.getApprovalType()).isEmpty()).collect(Collectors.groupingBy(roleApproval -> (Role)this.roleManager.findRoleFromPersistentString(((DatarouterUserRoleApprovalKey)roleApproval.getKey()).getRequestedRole()).get(), Collectors.groupingBy(roleApproval -> (RoleApprovalType)this.roleManager.findRoleApprovalTypeFromPersistentString(roleApproval.getApprovalType()).get(), Collectors.mapping(roleApproval -> ((DatarouterUserRoleApprovalKey)roleApproval.getKey()).getApproverUsername(), Collectors.toSet()))));
    }

    public List<UserRoleMetadata> getRoleMetadataForUser(DatarouterUser editor, DatarouterUser user) {
        HashSet currentRoles = new HashSet(user.getRoles());
        Set availableRoles = this.roleManager.getAllRoles();
        Map roleApprovalRequirements = this.roleManager.getAllRoleApprovalRequirements();
        Map<Role, Map<RoleApprovalType, Set<String>>> currentRoleApprovals = this.getCurrentRoleApprovals(user);
        HashSet relevantApprovalTypes = new HashSet();
        Scanner.of(roleApprovalRequirements.values()).map(Map::keySet).forEach(relevantApprovalTypes::addAll);
        List prioritizedApprovalTypes = this.roleManager.getPrioritizedRoleApprovalTypes(editor, user, relevantApprovalTypes);
        return (List)Scanner.of((Iterable)availableRoles).map(availableRole -> {
            Map requirementsOfRole = roleApprovalRequirements.getOrDefault(availableRole, new HashMap());
            Map currentApprovalsForRole = currentRoleApprovals.getOrDefault(availableRole, new HashMap());
            Map requirementStatusByApprovalType = Scanner.of(requirementsOfRole.keySet()).toMap(Function.identity(), roleApprovalType -> new RoleApprovalRequirementStatus((Integer)requirementsOfRole.get(roleApprovalType), currentApprovalsForRole.getOrDefault(roleApprovalType, new HashSet())));
            boolean rolePrivilegesGranted = currentRoles.contains(availableRole);
            Optional<Object> currentEditorPreviouslyApprovedType = Optional.empty();
            for (RoleApprovalType approvalType2 : currentApprovalsForRole.keySet()) {
                if (!((Set)currentApprovalsForRole.get(approvalType2)).contains(editor.getUsername())) continue;
                if (!requirementStatusByApprovalType.containsKey(approvalType2)) {
                    this.roleApprovalDao.deleteOutstandingApprovalsOfApprovalTypeForRole(availableRole.persistentString, approvalType2.persistentString());
                    continue;
                }
                currentEditorPreviouslyApprovedType = Optional.of(approvalType2);
            }
            Optional<Object> prioritizedApprovalType = !rolePrivilegesGranted ? (currentEditorPreviouslyApprovedType.isPresent() ? currentEditorPreviouslyApprovedType : prioritizedApprovalTypes.stream().filter(approvalType -> requirementStatusByApprovalType.containsKey(approvalType) && ((RoleApprovalRequirementStatus)requirementStatusByApprovalType.get(approvalType)).currentApprovers().size() < ((RoleApprovalRequirementStatus)requirementStatusByApprovalType.get(approvalType)).requiredApprovals()).findFirst()) : prioritizedApprovalTypes.stream().filter(requirementStatusByApprovalType::containsKey).findFirst();
            boolean canRevoke = !DatarouterUserRole.DATAROUTER_ADMIN.getPersistentString().equals(availableRole.getPersistentString()) && this.isDatarouterAdmin(editor) || user.equals((Object)editor);
            return new UserRoleMetadata((Role)availableRole, currentRoles.contains(availableRole), requirementStatusByApprovalType, (Optional<RoleApprovalType>)prioritizedApprovalType, Optional.of(canRevoke));
        }).collect(Collectors.toList());
    }
}

