/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.service;

import io.datarouter.auth.cache.DatarouterUserByIdCache;
import io.datarouter.auth.cache.DatarouterUserByUserTokenCache;
import io.datarouter.auth.cache.DatarouterUserByUsernameCache;
import io.datarouter.auth.service.UserInfo;
import io.datarouter.auth.storage.user.DatarouterUserDao;
import io.datarouter.scanner.Scanner;
import io.datarouter.util.string.StringTool;
import io.datarouter.web.user.databean.DatarouterUser;
import io.datarouter.web.user.databean.DatarouterUserKey;
import io.datarouter.web.user.role.Role;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

@Singleton
public class DatarouterUserInfo
implements UserInfo {
    @Inject
    private DatarouterUserDao userDao;
    @Inject
    private DatarouterUserByUsernameCache datarouterUserByUsernameCache;
    @Inject
    private DatarouterUserByUserTokenCache datarouterUserByUserTokenCache;
    @Inject
    private DatarouterUserByIdCache datarouterUserByIdCache;

    public Scanner<DatarouterUser> scanAllUsers(boolean enabledOnly, Set<Role> includedRoles) {
        if (includedRoles.isEmpty()) {
            return Scanner.empty();
        }
        return this.userDao.scan().include(user -> !enabledOnly || user.getEnabled() != false).include(user -> user.getRoles().stream().anyMatch(includedRoles::contains));
    }

    public Optional<DatarouterUser> getUserByUsername(String username, boolean allowCached) {
        if (StringTool.isEmptyOrWhitespace((String)username)) {
            return Optional.empty();
        }
        if (allowCached) {
            return this.datarouterUserByUsernameCache.get(username);
        }
        return Optional.ofNullable(this.userDao.getByUsername(new DatarouterUser.DatarouterUserByUsernameLookup(username)));
    }

    public Optional<DatarouterUser> getUserByToken(String token, boolean allowCached) {
        if (StringTool.isEmptyOrWhitespace((String)token)) {
            return Optional.empty();
        }
        if (allowCached) {
            return this.datarouterUserByUserTokenCache.get(token);
        }
        return this.userDao.find(new DatarouterUser.DatarouterUserByUserTokenLookup(token));
    }

    public Optional<DatarouterUser> getUserById(Long id, boolean allowCached) {
        if (id == null) {
            return Optional.empty();
        }
        if (allowCached) {
            return this.datarouterUserByIdCache.get(id);
        }
        return this.userDao.find(new DatarouterUserKey(id));
    }

    private Set<Role> getRolesFromUser(Optional<? extends DatarouterUser> user) {
        return user.map(DatarouterUser::getRoles).map(HashSet::new).orElseGet(HashSet::new);
    }

    @Override
    public Set<Role> getRolesByUsername(String username, boolean allowCached) {
        return this.getRolesFromUser(this.getUserByUsername(username, allowCached));
    }

    @Override
    public Set<Role> getRolesByToken(String token, boolean allowCached) {
        return this.getRolesFromUser(this.getUserByToken(token, allowCached));
    }

    @Override
    public Set<Role> getRolesById(Long id, boolean allowCached) {
        return this.getRolesFromUser(this.getUserById(id, allowCached));
    }
}

