/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.service;

import io.datarouter.auth.service.DatarouterUserEditService;
import io.datarouter.auth.service.DatarouterUserService;
import io.datarouter.auth.storage.permissionrequest.DatarouterPermissionRequest;
import io.datarouter.auth.storage.permissionrequest.DatarouterPermissionRequestDao;
import io.datarouter.auth.storage.user.DatarouterUserDao;
import io.datarouter.auth.storage.userhistory.DatarouterUserHistory;
import io.datarouter.auth.storage.userhistory.DatarouterUserHistoryDao;
import io.datarouter.auth.storage.userhistory.DatarouterUserHistoryKey;
import io.datarouter.email.html.J2HtmlDatarouterEmailBuilder;
import io.datarouter.email.type.DatarouterEmailTypes;
import io.datarouter.email.type.SimpleEmailType;
import io.datarouter.instrumentation.changelog.ChangelogRecorder;
import io.datarouter.model.databean.BaseDatabean;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.config.properties.AdminEmail;
import io.datarouter.storage.servertype.ServerTypeDetector;
import io.datarouter.web.email.DatarouterHtmlEmailService;
import io.datarouter.web.user.databean.DatarouterUser;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.PTag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

@Singleton
public class DatarouterUserHistoryService {
    public static final String CHANGELOG_TYPE = "DatarouterUserHistory";
    @Inject
    private AdminEmail adminEmail;
    @Inject
    private ChangelogRecorder changelogRecorder;
    @Inject
    private DatarouterUserDao baseDatarouterUserDao;
    @Inject
    private DatarouterUserHistoryDao baseDatarouterUserHistoryDao;
    @Inject
    private DatarouterPermissionRequestDao permissionRequestDao;
    @Inject
    private DatarouterUserService datarouterUserService;
    @Inject
    private DatarouterHtmlEmailService htmlEmailService;
    @Inject
    private DatarouterUserEditService userEditService;
    @Inject
    private DatarouterEmailTypes.PermissionRequestEmailType permissionRequestEmailType;
    @Inject
    private ServerTypeDetector serverTypeDetector;

    public Map<DatarouterPermissionRequest, Optional<HistoryChange>> getResolvedRequestToHistoryChangesMap(List<DatarouterPermissionRequest> requests) {
        Map historyMap = Scanner.of(requests).map(DatarouterPermissionRequest::toUserHistoryKey).map(key -> key.orElse(null)).include(Objects::nonNull).batch(100).map(this.baseDatarouterUserHistoryDao::getMulti).concat(Scanner::of).toMap(BaseDatabean::getKey, history -> new HistoryChange(history.getChanges(), Optional.ofNullable(this.datarouterUserService.getUserById(history.getEditor()))));
        return Scanner.of(requests).deduplicateConsecutive().toMap(Function.identity(), request -> request.toUserHistoryKey().map(historyKey -> historyMap.getOrDefault(historyKey, new HistoryChange(datarouterPermissionRequest.getResolution().persistentString, Optional.empty()))));
    }

    public void putAndRecordCreate(DatarouterUser user, Long editorId, String editorUsername, String description) {
        this.baseDatarouterUserDao.put(user);
        this.baseDatarouterUserHistoryDao.put(new DatarouterUserHistory(user.getId(), user.getCreatedInstant(), editorId, DatarouterUserHistory.DatarouterUserChangeType.CREATE, description));
        ChangelogRecorder.DatarouterChangelogDto dto = new ChangelogRecorder.DatarouterChangelogDtoBuilder(CHANGELOG_TYPE, user.getUsername(), DatarouterUserHistory.DatarouterUserChangeType.CREATE.persistentString, editorUsername).withComment(description).build();
        this.changelogRecorder.record(dto);
    }

    public void putAndRecordPasswordChange(DatarouterUser user, DatarouterUser editor, String signinUrl) {
        DatarouterUserHistory history = new DatarouterUserHistory(user.getId(), Instant.now(), editor.getId(), DatarouterUserHistory.DatarouterUserChangeType.RESET, "password");
        this.doPutAndRecordEdit(user, history);
        this.sendPasswordChangeEmail(user, history, signinUrl);
        ChangelogRecorder.DatarouterChangelogDto dto = new ChangelogRecorder.DatarouterChangelogDtoBuilder(CHANGELOG_TYPE, user.getUsername(), DatarouterUserHistory.DatarouterUserChangeType.RESET.persistentString, editor.getUsername()).build();
        this.changelogRecorder.record(dto);
    }

    public void putAndRecordEdit(DatarouterUser user, DatarouterUser editor, String changes, String signinUrl) {
        DatarouterUserHistory history = new DatarouterUserHistory(user.getId(), Instant.now(), editor.getId(), DatarouterUserHistory.DatarouterUserChangeType.EDIT, changes);
        this.doPutAndRecordEdit(user, history);
        this.sendRoleEditEmail(user, history, signinUrl);
        ChangelogRecorder.DatarouterChangelogDto dto = new ChangelogRecorder.DatarouterChangelogDtoBuilder(CHANGELOG_TYPE, user.getUsername(), DatarouterUserHistory.DatarouterUserChangeType.EDIT.persistentString, editor.getUsername()).withComment(changes).build();
        this.changelogRecorder.record(dto);
    }

    public void recordMessage(DatarouterUser user, DatarouterUser editor, String message) {
        this.baseDatarouterUserHistoryDao.put(new DatarouterUserHistory(user.getId(), Instant.now(), editor.getId(), DatarouterUserHistory.DatarouterUserChangeType.INFO, message));
    }

    public void recordDeprovisions(List<DatarouterUser> users, Optional<DatarouterUser> editor) {
        Instant time = Instant.now();
        Long editorId = editor.map(DatarouterUser::getId).orElse(1L);
        Map histories = Scanner.of(users).map(user -> new DatarouterUserHistory(user.getId(), time, editorId, DatarouterUserHistory.DatarouterUserChangeType.DEPROVISION, "deprovisioned")).flush(this.baseDatarouterUserHistoryDao::putMulti).toMap(history -> ((DatarouterUserHistoryKey)history.getKey()).getUserId());
        ((Scanner)Scanner.of(users).map(DatarouterUser::getId).listTo(this.permissionRequestDao::scanOpenPermissionRequestsForUsers)).map(request -> request.decline(time)).flush(this.permissionRequestDao::putMulti);
        editor.ifPresent(editorUser -> users.forEach(user -> this.sendDeprovisioningEmail((DatarouterUser)user, (DatarouterUserHistory)((Object)((Object)((Object)histories.get(user.getId())))), (DatarouterUser)editorUser)));
        this.recordProvisioningChangelogs(users, editor, DatarouterUserHistory.DatarouterUserChangeType.DEPROVISION);
    }

    public void recordRestores(List<DatarouterUser> users, Optional<DatarouterUser> editor) {
        Instant time = Instant.now();
        Long editorId = editor.map(DatarouterUser::getId).orElse(null);
        Scanner.of(users).map(user -> new DatarouterUserHistory(user.getId(), time, editorId, DatarouterUserHistory.DatarouterUserChangeType.RESTORE, "restored")).flush(this.baseDatarouterUserHistoryDao::putMulti);
        this.recordProvisioningChangelogs(users, editor, DatarouterUserHistory.DatarouterUserChangeType.RESTORE);
    }

    public List<DatarouterUserHistory> getHistoryForUser(Long userId) {
        return this.baseDatarouterUserHistoryDao.scanWithPrefix(new DatarouterUserHistoryKey(userId, null)).list();
    }

    private void recordProvisioningChangelogs(List<DatarouterUser> users, Optional<DatarouterUser> editor, DatarouterUserHistory.DatarouterUserChangeType action) {
        Scanner.of(users).map(DatarouterUser::getUsername).map(username -> new ChangelogRecorder.DatarouterChangelogDtoBuilder(CHANGELOG_TYPE, username, datarouterUserChangeType.persistentString, editor.map(DatarouterUser::getUsername).orElse(this.adminEmail.get()))).map(ChangelogRecorder.DatarouterChangelogDtoBuilder::build).forEach(arg_0 -> ((ChangelogRecorder)this.changelogRecorder).record(arg_0));
    }

    private void doPutAndRecordEdit(DatarouterUser user, DatarouterUserHistory history) {
        this.baseDatarouterUserDao.put(user);
        this.baseDatarouterUserHistoryDao.put(history);
        this.permissionRequestDao.scanOpenPermissionRequestsForUser(((DatarouterUserHistoryKey)history.getKey()).getUserId()).map(history::resolvePermissionRequest).flush(this.permissionRequestDao::putMulti);
    }

    private void sendPasswordChangeEmail(DatarouterUser user, DatarouterUserHistory history, String signInUrl) {
        DatarouterUser editor = this.datarouterUserService.getUserById(history.getEditor());
        PTag p1 = TagCreator.p((String)String.format("Your user (%s) password has been changed by user %s (%s).", user.getUsername(), editor.getId(), editor.getUsername()));
        PTag p2 = TagCreator.p((String)("Changes: " + history.getChanges()));
        DivTag content = TagCreator.div((DomContent[])new DomContent[]{p1, p2, DatarouterUserHistoryService.makeSignInParagraph(signInUrl)});
        J2HtmlDatarouterEmailBuilder emailBuilder = this.htmlEmailService.startEmailBuilder().withSubject(this.userEditService.getPermissionRequestEmailSubject(user)).withTitle("Password Changed").withTitleHref(signInUrl).withContent((DomContent)content).from(user.getUsername()).to(user.getUsername());
        this.htmlEmailService.trySendJ2Html(emailBuilder);
    }

    private void sendRoleEditEmail(DatarouterUser user, DatarouterUserHistory history, String signInUrl) {
        DatarouterUser editor = this.datarouterUserService.getUserById(history.getEditor());
        PTag p1 = TagCreator.p((String)String.format("%s permissions have been edited by %s", user.getUsername(), editor.getUsername()));
        PTag p2 = (PTag)TagCreator.p((String)("Changes: " + history.getChanges())).withStyle("white-space: pre-wrap");
        DivTag content = TagCreator.div((DomContent[])new DomContent[]{p1, p2, DatarouterUserHistoryService.makeSignInParagraph(signInUrl)});
        J2HtmlDatarouterEmailBuilder emailBuilder = this.htmlEmailService.startEmailBuilder().withSubject(this.userEditService.getPermissionRequestEmailSubject(user)).withTitle("Permissions Changed").withTitleHref(signInUrl).withContent((DomContent)content).from(user.getUsername()).to(user.getUsername()).to(editor.getUsername()).to((SimpleEmailType)this.permissionRequestEmailType, this.serverTypeDetector.mightBeProduction()).toSubscribers(this.serverTypeDetector.mightBeProduction()).toAdmin(this.serverTypeDetector.mightBeDevelopment());
        this.htmlEmailService.trySendJ2Html(emailBuilder);
    }

    private void sendDeprovisioningEmail(DatarouterUser user, DatarouterUserHistory history, DatarouterUser editor) {
        DivTag content = TagCreator.div((DomContent[])new DomContent[]{TagCreator.p((String)String.format("Your user (%s) has been %s by user %s (%s).", user.getUsername(), history.getChanges(), editor.getId(), editor.getUsername()))});
        J2HtmlDatarouterEmailBuilder emailBuilder = this.htmlEmailService.startEmailBuilder().withSubject(this.userEditService.getPermissionRequestEmailSubject(user)).withTitle("Permissions Changed").withContent((DomContent)content).from(user.getUsername()).to(user.getUsername());
        this.htmlEmailService.trySendJ2Html(emailBuilder);
    }

    private static PTag makeSignInParagraph(String signInUrl) {
        return TagCreator.p((DomContent[])new DomContent[]{TagCreator.text((String)"Please sign in again to refresh your session: "), TagCreator.a((String)"sign in").withHref(signInUrl)});
    }

    public record HistoryChange(String changes, Optional<DatarouterUser> editor) {
    }
}

