/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.service;

import io.datarouter.auth.storage.account.DatarouterAccount;
import io.datarouter.auth.storage.account.DatarouterAccountDao;
import io.datarouter.auth.storage.account.DatarouterAccountKey;
import io.datarouter.util.cache.LoadingCache;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.time.Duration;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;

@Singleton
public class DatarouterAccountRefererService {
    private final LoadingCache<String, RefererCheck> checkByAccountName = new LoadingCache.LoadingCacheBuilder().withName("AccountRefererCheck").withExpireTtl(Duration.ofMinutes(1L)).withLoadingFunction(accountName -> {
        DatarouterAccount account = accountDao.get(new DatarouterAccountKey((String)accountName));
        String referer = account.getReferrer();
        if (referer == null) {
            return $ -> new DatarouterAccountRefererCheck(true, false);
        }
        return request -> {
            String reqReferer = request.getHeader("referer");
            boolean allowed = reqReferer != null && reqReferer.startsWith(referer);
            return new DatarouterAccountRefererCheck(allowed, true);
        };
    }).build();

    @Inject
    public DatarouterAccountRefererService(DatarouterAccountDao accountDao) {
    }

    public DatarouterAccountRefererCheck validateAccountReferer(String accountName, HttpServletRequest request) {
        return (DatarouterAccountRefererCheck)((RefererCheck)this.checkByAccountName.getOrThrow((Object)accountName)).apply(request);
    }

    public record DatarouterAccountRefererCheck(boolean allowed, boolean hasRefererValidation) {
    }

    private static interface RefererCheck
    extends Function<HttpServletRequest, DatarouterAccountRefererCheck> {
    }
}

