/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.service;

import io.datarouter.auth.service.DefaultDatarouterAccountKeysSupplier;
import io.datarouter.auth.storage.account.BaseDatarouterAccountCredentialDao;
import io.datarouter.auth.storage.account.BaseDatarouterAccountDao;
import io.datarouter.auth.storage.account.DatarouterAccount;
import io.datarouter.auth.storage.account.DatarouterAccountCredential;
import io.datarouter.auth.storage.account.DatarouterAccountCredentialKey;
import io.datarouter.auth.storage.account.DatarouterAccountKey;
import io.datarouter.auth.storage.accountpermission.BaseDatarouterAccountPermissionDao;
import io.datarouter.auth.storage.accountpermission.DatarouterAccountPermission;
import io.datarouter.auth.storage.useraccountmap.BaseDatarouterUserAccountMapDao;
import io.datarouter.auth.storage.useraccountmap.DatarouterUserAccountMap;
import io.datarouter.storage.servertype.ServerTypeDetector;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DatarouterAccountConfigAppListenerService {
    private static final Logger logger = LoggerFactory.getLogger(DatarouterAccountConfigAppListenerService.class);
    public static final String DEFAULT_ACCOUNT_NAME = "default";
    private static final long DEFAULT_ADMIN_ID = 1L;
    private static final String DEFAULT_ACCOUNT_CREATOR = "defaultCreator";
    private static final String DEFAULT_ENDPOINT_ACCESS = "all";
    @Inject
    private BaseDatarouterAccountDao datarouterAccountDao;
    @Inject
    private BaseDatarouterAccountCredentialDao datarouterAccountCredentialDao;
    @Inject
    private BaseDatarouterUserAccountMapDao userAccountMapDao;
    @Inject
    private BaseDatarouterAccountPermissionDao accountPermissionDao;
    @Inject
    private DefaultDatarouterAccountKeysSupplier defaultDatarouterAccountKeys;
    @Inject
    private ServerTypeDetector serverTypeDetector;

    public void createDefaultAccountRecords() {
        if (this.serverTypeDetector.mightBeProduction()) {
            return;
        }
        this.createDefaultAccountAndAdminUser();
        this.createDefaultAccountPermission();
    }

    private void createDefaultAccountAndAdminUser() {
        boolean keyExists;
        boolean accountExists;
        DatarouterAccount defaultAccount = this.datarouterAccountDao.get(new DatarouterAccountKey(DEFAULT_ACCOUNT_NAME));
        boolean bl = accountExists = defaultAccount != null && defaultAccount.getEnableUserMappings();
        if (!accountExists) {
            if (defaultAccount == null) {
                defaultAccount = new DatarouterAccount(DEFAULT_ACCOUNT_NAME, new Date(), DEFAULT_ACCOUNT_CREATOR);
            }
            defaultAccount.setEnableUserMappings(true);
            this.datarouterAccountDao.put(defaultAccount);
            logger.warn("Created default DatarouterAccount");
            DatarouterUserAccountMap userAccountMap = new DatarouterUserAccountMap(1L, DEFAULT_ACCOUNT_NAME);
            this.userAccountMapDao.put(userAccountMap);
            logger.warn("Mapped the default admin user to the default account");
        }
        String defaultApiKey = this.defaultDatarouterAccountKeys.getDefaultApiKey();
        String defaultSecretKey = this.defaultDatarouterAccountKeys.getDefaultSecretKey();
        DatarouterAccountCredentialKey accountCredsKey = new DatarouterAccountCredentialKey(defaultApiKey);
        DatarouterAccountCredential accountCreds = this.datarouterAccountCredentialDao.get(accountCredsKey);
        boolean bl2 = keyExists = accountCreds != null && defaultSecretKey.equals(accountCreds.getSecretKey());
        if (!keyExists) {
            accountCreds = new DatarouterAccountCredential(defaultApiKey, defaultSecretKey, DEFAULT_ACCOUNT_NAME, DEFAULT_ACCOUNT_CREATOR);
            this.datarouterAccountCredentialDao.put(accountCreds);
            logger.warn("Created default DatarouterAccountCredential");
        }
    }

    private void createDefaultAccountPermission() {
        DatarouterAccountPermission permission = new DatarouterAccountPermission(DEFAULT_ACCOUNT_NAME, DEFAULT_ENDPOINT_ACCESS);
        this.accountPermissionDao.put(permission);
        logger.warn("Created default DatarouterAccountPermission");
    }
}

