/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.config;

import io.datarouter.auth.config.DatarouterAuthPaths;
import io.datarouter.auth.web.DatarouterPermissionRequestHandler;
import io.datarouter.auth.web.DatarouterSigninHandler;
import io.datarouter.auth.web.DatarouterSignoutHandler;
import io.datarouter.auth.web.adminedituser.AdminEditUserHandler;
import io.datarouter.pathnode.PathNode;
import io.datarouter.storage.tag.Tag;
import io.datarouter.web.dispatcher.BaseRouteSet;
import io.datarouter.web.dispatcher.DispatchRule;
import io.datarouter.web.user.role.DatarouterUserRole;
import io.datarouter.web.user.role.RoleEnum;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;

@Singleton
public class DatarouterAuthRouteSet
extends BaseRouteSet {
    @Inject
    public DatarouterAuthRouteSet(DatarouterAuthPaths paths) {
        this.handle((PathNode)paths.signin).withHandler(DatarouterSigninHandler.class).allowAnonymous();
        this.handle(paths.signout).withHandler(DatarouterSignoutHandler.class).allowAnonymous();
        this.handle(paths.admin.createUser).withHandler(AdminEditUserHandler.class);
        this.handle(paths.admin.createUserSubmit).withHandler(AdminEditUserHandler.class);
        this.handle(paths.admin.editUser).withHandler(AdminEditUserHandler.class).allowRoles(new RoleEnum[]{DatarouterUserRole.REQUESTOR});
        this.handle(paths.admin.getUserDetails).withHandler(AdminEditUserHandler.class).allowRoles(new RoleEnum[]{DatarouterUserRole.REQUESTOR});
        this.handle(paths.admin.getUserProfileImage).withHandler(AdminEditUserHandler.class);
        this.handle(paths.admin.listUsers).withHandler(AdminEditUserHandler.class);
        this.handle(paths.admin.updatePassword).withHandler(AdminEditUserHandler.class);
        this.handle(paths.admin.editRoles).withHandler(AdminEditUserHandler.class).allowRoles(new RoleEnum[]{DatarouterUserRole.REQUESTOR});
        this.handle(paths.admin.editAccounts).withHandler(AdminEditUserHandler.class);
        this.handle(paths.admin.updateTimeZone).withHandler(AdminEditUserHandler.class);
        this.handle(paths.admin.copyUser).withHandler(AdminEditUserHandler.class);
        this.handle(paths.admin.viewUsers).withHandler(AdminEditUserHandler.class);
        this.handleDir((PathNode)paths.permissionRequest).withHandler(DatarouterPermissionRequestHandler.class).allowRoles(new RoleEnum[]{DatarouterUserRole.REQUESTOR});
    }

    protected DispatchRule applyDefault(DispatchRule rule) {
        return rule.allowRoles(new RoleEnum[]{DatarouterUserRole.ADMIN, DatarouterUserRole.DATAROUTER_ADMIN}).withTag(Tag.DATAROUTER);
    }
}

