/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.web;

import io.datarouter.auth.service.AccountCallerTypeRegistry2;
import io.datarouter.auth.storage.account.DatarouterAccount;
import io.datarouter.auth.storage.account.DatarouterAccountDao;
import io.datarouter.auth.storage.account.DatarouterAccountKey;
import io.datarouter.httpclient.endpoint.caller.CallerType;
import io.datarouter.instrumentation.changelog.ChangelogRecorder;
import io.datarouter.util.lang.ReflectionTool;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.handler.types.Param;
import io.datarouter.web.handler.types.optional.OptionalString;
import io.datarouter.web.html.form.HtmlForm;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4FormHtml;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4PageFactory;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.FormTag;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

public class DatarouterAccountCallerTypeHandler
extends BaseHandler {
    private static final String P_accountName = "accountName";
    private static final String P_callerType = "callerType";
    private static final String P_submitAction = "submitAction";
    @Inject
    private DatarouterAccountDao accountDao;
    @Inject
    private ChangelogRecorder changelogRecorder;
    @Inject
    private Bootstrap4PageFactory pageFactory;
    @Inject
    private AccountCallerTypeRegistry2 accountCallerTypeRegistry;

    @BaseHandler.Handler(defaultHandler=true)
    public Mav updateCallerType(@Param(value="accountName") OptionalString accountName, @Param(value="callerType") OptionalString callerType, @Param(value="submitAction") OptionalString submitAction) {
        List possibleOldAccountNames = this.accountDao.scanKeys().map(DatarouterAccountKey::getAccountName).sort().list();
        List<String> possibleCallerTypes = this.accountCallerTypeRegistry.get().stream().map(ReflectionTool::create).map(CallerType::getName).sorted().distinct().toList();
        HtmlForm form = new HtmlForm().withMethod("post");
        form.addSelectField().withDisplay("Account Name").withName(P_accountName).withValues(possibleOldAccountNames);
        form.addSelectField().withDisplay("Caller Type").withName(P_callerType).withValues(possibleCallerTypes);
        form.addButton().withDisplay("Update").withValue("anything");
        if (submitAction.isEmpty() || form.hasErrors()) {
            return this.pageFactory.startBuilder(this.request).withTitle("Datarouter Account Update Caller Type").withContent((DomContent)Html.makeContent(form)).buildMav();
        }
        this.updateCallerType((String)accountName.get(), (String)callerType.get());
        return this.pageFactory.message(this.request, "Account=" + (String)accountName.get() + " updated callerType to=" + (String)callerType.get());
    }

    private void updateCallerType(String accountName, String callerType) {
        DatarouterAccount account = this.accountDao.get(new DatarouterAccountKey(accountName));
        String perviousCallerType = Optional.ofNullable(account.getCallerType()).orElse("");
        account.setCallerType(callerType);
        this.accountDao.put(account);
        ChangelogRecorder.DatarouterChangelogDto dto = new ChangelogRecorder.DatarouterChangelogDtoBuilder("DatarouterAccount", accountName, P_callerType, this.getSessionInfo().findNonEmptyUsername().orElse("")).withComment(String.valueOf(perviousCallerType) + "->" + callerType).build();
        this.changelogRecorder.record(dto);
    }

    private static class Html {
        private Html() {
        }

        public static DivTag makeContent(HtmlForm htmlForm) {
            FormTag form = (FormTag)Bootstrap4FormHtml.render((HtmlForm)htmlForm).withClass("card card-body bg-light");
            return (DivTag)TagCreator.div((DomContent[])new DomContent[]{TagCreator.h2((String)"Datarouter Account Caller Type Updater"), form, TagCreator.br()}).withClass("container mt-3");
        }
    }
}

