/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.storage.account;

import io.datarouter.auth.storage.account.DatarouterAccountKey;
import io.datarouter.model.databean.BaseDatabean;
import io.datarouter.model.field.Field;
import io.datarouter.model.field.imp.DateField;
import io.datarouter.model.field.imp.DateFieldKey;
import io.datarouter.model.field.imp.StringField;
import io.datarouter.model.field.imp.StringFieldKey;
import io.datarouter.model.field.imp.comparable.BooleanField;
import io.datarouter.model.field.imp.comparable.BooleanFieldKey;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.BaseDatabeanFielder;
import io.datarouter.util.time.ZonedDateFormatterTool;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.function.Supplier;

public class DatarouterAccount
extends BaseDatabean<DatarouterAccountKey, DatarouterAccount> {
    private Date created;
    private String creator;
    private Date lastUsed;
    private Boolean enableUserMappings;
    public String callerType;
    public String referrer;

    public DatarouterAccount() {
        super((PrimaryKey)new DatarouterAccountKey());
    }

    public DatarouterAccount(String accountName, Date created, String creator) {
        super((PrimaryKey)new DatarouterAccountKey(accountName));
        this.created = created;
        this.creator = creator;
        this.enableUserMappings = false;
        this.callerType = null;
        this.referrer = null;
    }

    public DatarouterAccount(String accountName, DatarouterAccount account) {
        this(accountName, account.getCreated(), account.getCreator());
        this.enableUserMappings = account.getEnableUserMappings();
        this.lastUsed = account.getLastUsed();
        this.callerType = account.getCallerType();
        this.referrer = account.getReferrer();
    }

    public Supplier<DatarouterAccountKey> getKeySupplier() {
        return DatarouterAccountKey::new;
    }

    public String getCreatedDate(ZoneId zoneId) {
        if (this.created == null) {
            return "";
        }
        return ZonedDateFormatterTool.formatDateWithZone((Date)this.created, (ZoneId)zoneId);
    }

    public String getCreator() {
        return this.creator;
    }

    public void setLastUsed(Date lastUsed) {
        this.lastUsed = lastUsed;
    }

    public String getLastUsedDate(ZoneId zoneId) {
        if (this.lastUsed == null) {
            return "";
        }
        return ZonedDateFormatterTool.formatDateWithZone((Date)this.lastUsed, (ZoneId)zoneId);
    }

    public Date getLastUsed() {
        return this.lastUsed;
    }

    public Instant getLastUsedInstant() {
        if (this.lastUsed == null) {
            return Instant.MIN;
        }
        return this.lastUsed.toInstant();
    }

    public void toggleUserMappings() {
        this.enableUserMappings = this.enableUserMappings == null ? Boolean.valueOf(true) : Boolean.valueOf(this.enableUserMappings == false);
    }

    public boolean getEnableUserMappings() {
        if (this.enableUserMappings == null) {
            return false;
        }
        return this.enableUserMappings;
    }

    public void setEnableUserMappings(boolean enableUserMappings) {
        this.enableUserMappings = enableUserMappings;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCallerType(String callerType) {
        this.callerType = callerType;
    }

    public String getCallerType() {
        return this.callerType;
    }

    public String getReferrer() {
        return this.referrer;
    }

    public static class DatarouterAccountFielder
    extends BaseDatabeanFielder<DatarouterAccountKey, DatarouterAccount> {
        public DatarouterAccountFielder() {
            super(DatarouterAccountKey::new);
        }

        public List<Field<?>> getNonKeyFields(DatarouterAccount account) {
            return List.of(new DateField(FieldKeys.created, account.created), new StringField(FieldKeys.creator, account.creator), new DateField(FieldKeys.lastUsed, account.lastUsed), new BooleanField(FieldKeys.enableUserMappings, account.enableUserMappings), new StringField(FieldKeys.callerType, account.callerType), new StringField(FieldKeys.referrer, account.referrer));
        }
    }

    private static class FieldKeys {
        private static final DateFieldKey created = new DateFieldKey("created");
        private static final StringFieldKey creator = new StringFieldKey("creator");
        private static final DateFieldKey lastUsed = new DateFieldKey("lastUsed");
        private static final BooleanFieldKey enableUserMappings = new BooleanFieldKey("enableUserMappings");
        private static final StringFieldKey callerType = new StringFieldKey("callerType");
        private static final StringFieldKey referrer = new StringFieldKey("referrer");

        private FieldKeys() {
        }
    }
}

