/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.service;

import io.datarouter.auth.config.DatarouterAuthPaths;
import io.datarouter.auth.storage.user.DatarouterUserDao;
import io.datarouter.email.html.J2HtmlEmailTable;
import io.datarouter.storage.servertype.ServerTypeDetector;
import io.datarouter.web.digest.DailyDigest;
import io.datarouter.web.digest.DailyDigestGrouping;
import io.datarouter.web.digest.DailyDigestService;
import io.datarouter.web.html.j2html.J2HtmlTable;
import io.datarouter.web.user.databean.DatarouterUser;
import io.datarouter.web.user.databean.DatarouterUserKey;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.H3Tag;
import j2html.tags.specialized.TableTag;
import java.time.ZoneId;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DatarouterDefaultUserDailyDigest
implements DailyDigest {
    @Inject
    private DatarouterUserDao datarouterUserDao;
    @Inject
    private DailyDigestService dailyDigestService;
    @Inject
    private DatarouterAuthPaths authPaths;
    @Inject
    private ServerTypeDetector serverTypeDetector;

    private Optional<String> findDefaultUsername() {
        Long defaultAdminId = 1L;
        return this.datarouterUserDao.find(new DatarouterUserKey(defaultAdminId)).map(DatarouterUser::getUsername);
    }

    public Optional<DivTag> getPageContent(ZoneId zoneId) {
        if (!this.serverTypeDetector.mightBeProduction()) {
            return Optional.empty();
        }
        Optional<List> username = this.findDefaultUsername().map(List::of);
        if (username.isEmpty()) {
            return Optional.empty();
        }
        H3Tag header = this.dailyDigestService.makeHeader("Please remove the default user", this.authPaths.admin.viewUsers);
        TableTag table = this.buildTable(username.get());
        return Optional.of(TagCreator.div((DomContent[])new DomContent[]{header, table}));
    }

    public Optional<DivTag> getEmailContent(ZoneId zoneId) {
        if (!this.serverTypeDetector.mightBeProduction()) {
            return Optional.empty();
        }
        Optional<List> username = this.findDefaultUsername().map(List::of);
        if (username.isEmpty()) {
            return Optional.empty();
        }
        H3Tag header = this.dailyDigestService.makeHeader("Please remove the default user", this.authPaths.admin.viewUsers);
        TableTag table = this.buildEmailTable(username.get());
        return Optional.of(TagCreator.div((DomContent[])new DomContent[]{header, table}));
    }

    public String getTitle() {
        return "Users with default userIds";
    }

    public DailyDigestGrouping getGrouping() {
        return DailyDigestGrouping.MEDIUM;
    }

    public DailyDigest.DailyDigestType getType() {
        return DailyDigest.DailyDigestType.ACTIONABLE;
    }

    public TableTag buildTable(List<String> rows) {
        return new J2HtmlTable().withClasses(new String[]{"sortable table table-sm table-striped my-4 border"}).withColumn("Users", row -> row).build(rows);
    }

    private TableTag buildEmailTable(List<String> rows) {
        return new J2HtmlEmailTable().withColumn("Users", row -> row).build(rows);
    }
}

