/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.service;

import io.datarouter.auth.config.DatarouterAuthPaths;
import io.datarouter.auth.service.DefaultDatarouterAccountKeysSupplier;
import io.datarouter.auth.storage.account.BaseDatarouterAccountCredentialDao;
import io.datarouter.auth.storage.account.DatarouterAccountCredential;
import io.datarouter.auth.storage.account.DatarouterAccountCredentialKey;
import io.datarouter.email.html.J2HtmlEmailTable;
import io.datarouter.pathnode.PathNode;
import io.datarouter.util.string.StringTool;
import io.datarouter.web.digest.DailyDigest;
import io.datarouter.web.digest.DailyDigestGrouping;
import io.datarouter.web.digest.DailyDigestService;
import io.datarouter.web.html.j2html.J2HtmlTable;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.H3Tag;
import j2html.tags.specialized.TableTag;
import java.time.ZoneId;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DatarouterDefaultAccountKeysDailyDigest
implements DailyDigest {
    @Inject
    private DefaultDatarouterAccountKeysSupplier defaultDatarouterAccountKeys;
    @Inject
    private DailyDigestService dailyDigestService;
    @Inject
    private BaseDatarouterAccountCredentialDao datarouterAccountCredentialDao;
    @Inject
    private DatarouterAuthPaths authPaths;

    private List<String> getAccounts() {
        return this.datarouterAccountCredentialDao.scan().include(credential -> StringTool.equalsCaseInsensitive((String)((DatarouterAccountCredentialKey)credential.getKey()).getApiKey(), (String)this.defaultDatarouterAccountKeys.getDefaultApiKey()) || StringTool.equalsCaseInsensitive((String)credential.getSecretKey(), (String)this.defaultDatarouterAccountKeys.getDefaultSecretKey())).map(DatarouterAccountCredential::getAccountName).list();
    }

    public Optional<DivTag> getPageContent(ZoneId zoneId) {
        List<String> accounts = this.getAccounts();
        if (accounts.isEmpty()) {
            return Optional.empty();
        }
        H3Tag header = this.dailyDigestService.makeHeader("Account Credentials with default api or secret keys", (PathNode)this.authPaths.datarouter.accountManager);
        TableTag table = this.buildTable(accounts);
        return Optional.of(TagCreator.div((DomContent[])new DomContent[]{header, table}));
    }

    public Optional<DivTag> getEmailContent(ZoneId zoneId) {
        List<String> accounts = this.getAccounts();
        if (accounts.isEmpty()) {
            return Optional.empty();
        }
        H3Tag header = this.dailyDigestService.makeHeader("Account Credentials with default api or secret keys", (PathNode)this.authPaths.datarouter.accountManager);
        TableTag table = this.buildEmailTable(accounts);
        return Optional.of(TagCreator.div((DomContent[])new DomContent[]{header, table}));
    }

    public String getTitle() {
        return "Accounts with default keys";
    }

    public DailyDigestGrouping getGrouping() {
        return DailyDigestGrouping.MEDIUM;
    }

    public DailyDigest.DailyDigestType getType() {
        return DailyDigest.DailyDigestType.ACTIONABLE;
    }

    public TableTag buildTable(List<String> rows) {
        return new J2HtmlTable().withClasses(new String[]{"sortable table table-sm table-striped my-4 border"}).withColumn("Accounts", row -> row).build(rows);
    }

    private TableTag buildEmailTable(List<String> rows) {
        return new J2HtmlEmailTable().withColumn("Accounts", row -> row).build(rows);
    }
}

