/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.service;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import io.datarouter.auth.storage.account.DatarouterAccountDao;
import io.datarouter.auth.storage.account.DatarouterAccountKey;
import java.time.Duration;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class CallerTypeByAccountNameCache {
    private final LoadingCache<String, String> cache;

    @Inject
    public CallerTypeByAccountNameCache(final DatarouterAccountDao datarouterAccountDao) {
        CacheLoader<String, String> cacheLoader = new CacheLoader<String, String>(){

            public String load(String key) {
                return datarouterAccountDao.get(new DatarouterAccountKey(key)).getCallerType();
            }
        };
        this.cache = Caffeine.newBuilder().refreshAfterWrite(Duration.ofSeconds(15L)).maximumSize(100L).build((CacheLoader)cacheLoader);
    }

    public String get(String accountName) {
        return (String)this.cache.get((Object)accountName);
    }
}

