/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.service;

import io.datarouter.plugin.PluginConfigKey;
import io.datarouter.plugin.PluginConfigType;
import io.datarouter.plugin.PluginConfigValue;
import io.datarouter.plugin.PluginInjector;
import io.datarouter.scanner.Scanner;
import io.datarouter.web.user.session.service.Role;
import io.datarouter.web.user.session.service.SessionBasedUser;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;

public interface UserInfo
extends PluginConfigValue<UserInfo> {
    public static final PluginConfigKey<UserInfo> KEY = new PluginConfigKey("userInfo", PluginConfigType.CLASS_SINGLE);

    public Scanner<? extends SessionBasedUser> scanAllUsers(boolean var1, Set<Role> var2);

    public Optional<? extends SessionBasedUser> getUserByUsername(String var1, boolean var2);

    public Optional<? extends SessionBasedUser> getUserByToken(String var1, boolean var2);

    public Optional<? extends SessionBasedUser> getUserById(Long var1, boolean var2);

    public Set<Role> getRolesByUsername(String var1, boolean var2);

    public Set<Role> getRolesByToken(String var1, boolean var2);

    public Set<Role> getRolesById(Long var1, boolean var2);

    default public Boolean hasRoleByUsername(String username, Role role, boolean allowCached) {
        return this.getRolesByUsername(username, allowCached).contains(role);
    }

    default public Boolean hasRoleByToken(String token, Role role, boolean allowCached) {
        return this.getRolesByToken(token, allowCached).contains(role);
    }

    default public Boolean hasRoleById(Long id, Role role, boolean allowCached) {
        return this.getRolesById(id, allowCached).contains(role);
    }

    default public PluginConfigKey<UserInfo> getKey() {
        return KEY;
    }

    @Singleton
    public static class UserInfoSupplier
    implements Supplier<UserInfo> {
        @Inject
        private PluginInjector injector;

        @Override
        public UserInfo get() {
            return (UserInfo)this.injector.getInstance(KEY);
        }
    }
}

