/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.service;

import io.datarouter.auth.config.DatarouterAuthPaths;
import io.datarouter.auth.service.UserInfo;
import io.datarouter.auth.storage.permissionrequest.DatarouterPermissionRequestDao;
import io.datarouter.auth.storage.permissionrequest.DatarouterPermissionRequestKey;
import io.datarouter.email.html.J2HtmlEmailTable;
import io.datarouter.model.databean.BaseDatabean;
import io.datarouter.scanner.OptionalScanner;
import io.datarouter.util.time.ZonedDateFormatterTool;
import io.datarouter.web.config.ServletContextSupplier;
import io.datarouter.web.digest.DailyDigest;
import io.datarouter.web.digest.DailyDigestGrouping;
import io.datarouter.web.digest.DailyDigestService;
import io.datarouter.web.html.j2html.J2HtmlTable;
import io.datarouter.web.user.detail.DatarouterUserExternalDetailService;
import io.datarouter.web.user.detail.DatarouterUserProfileLink;
import io.datarouter.web.user.session.service.SessionBasedUser;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.ATag;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.H3Tag;
import j2html.tags.specialized.TableTag;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.ServletContext;

@Singleton
public class PermissionRequestDailyDigest
implements DailyDigest {
    @Inject
    private DatarouterPermissionRequestDao permissionRequestDao;
    @Inject
    private ServletContextSupplier servletContextSupplier;
    @Inject
    private DatarouterAuthPaths paths;
    @Inject
    private DatarouterUserExternalDetailService detailsService;
    @Inject
    private UserInfo.UserInfoSupplier userInfo;
    @Inject
    private DailyDigestService digestService;

    public Optional<DivTag> getPageContent(ZoneId zoneId) {
        List<PermissionRequestDto> openRequests = this.getOpenRequests();
        if (openRequests.size() == 0) {
            return Optional.empty();
        }
        H3Tag header = this.digestService.makeHeader("Open Permission Requests", this.paths.admin.viewUsers);
        TableTag table = this.buildPageTable(openRequests, zoneId);
        return Optional.of(TagCreator.div((DomContent[])new DomContent[]{header, table}));
    }

    public Optional<DivTag> getEmailContent(ZoneId zoneId) {
        List<PermissionRequestDto> openRequests = this.getOpenRequests();
        if (openRequests.size() == 0) {
            return Optional.empty();
        }
        H3Tag header = this.digestService.makeHeader("Open Permission Requests", this.paths.admin.viewUsers);
        TableTag table = this.buildEmailTable(openRequests, zoneId);
        return Optional.of(TagCreator.div((DomContent[])new DomContent[]{header, table}));
    }

    public String getTitle() {
        return "Permission Requests";
    }

    public DailyDigestGrouping getGrouping() {
        return DailyDigestGrouping.HIGH;
    }

    public DailyDigest.DailyDigestType getType() {
        return DailyDigest.DailyDigestType.ACTIONABLE;
    }

    private List<PermissionRequestDto> getOpenRequests() {
        return this.permissionRequestDao.scanOpenPermissionRequests().map(BaseDatabean::getKey).map(key -> Optional.of(key).map(DatarouterPermissionRequestKey::getUserId).map(id -> this.userInfo.get().getUserById((Long)id, true)).filter(Optional::isPresent).map(Optional::get).map(user -> new PermissionRequestDto((SessionBasedUser)user, key.getRequestTime()))).concat(OptionalScanner::of).sort(Comparator.comparing(dto -> dto.user.getUsername())).list();
    }

    private TableTag buildPageTable(List<PermissionRequestDto> rows, ZoneId zoneId) {
        return new J2HtmlTable().withClasses(new String[]{"table table-sm table-striped my-4 border"}).withColumn("Username", row -> row.user.getUsername()).withHtmlColumn("Profile", row -> {
            String username = row.user.getUsername();
            DatarouterUserProfileLink detailsLink = (DatarouterUserProfileLink)this.detailsService.getUserProfileLink(username).get();
            return TagCreator.td((DomContent[])new DomContent[]{TagCreator.a((String)detailsLink.name()).withHref(detailsLink.url())});
        }).withColumn("Date Requested", row -> row.getInstantRequested(zoneId)).withHtmlColumn("Details", row -> {
            String link = String.valueOf(((ServletContext)this.servletContextSupplier.get()).getContextPath()) + this.paths.admin.editUser.toSlashedString() + "?username=" + row.user.getUsername();
            return TagCreator.td((DomContent[])new DomContent[]{((ATag)TagCreator.a((DomContent[])new DomContent[]{TagCreator.i().withClass("fa fa-link")}).withClass("btn btn-link w-100 py-0")).withHref(link)});
        }).build(rows);
    }

    private TableTag buildEmailTable(List<PermissionRequestDto> rows, ZoneId zoneId) {
        return new J2HtmlEmailTable().withColumn("Username", row -> row.user.getUsername()).withColumn(new J2HtmlEmailTable.J2HtmlEmailTableColumn("Profile", row -> {
            String username = row.user.getUsername();
            DatarouterUserProfileLink detailsLink = (DatarouterUserProfileLink)this.detailsService.getUserProfileLink(username).get();
            return TagCreator.a((String)detailsLink.name()).withHref(detailsLink.url());
        })).withColumn("Date Requested", row -> row.getInstantRequested(zoneId)).withColumn(new J2HtmlEmailTable.J2HtmlEmailTableColumn("Details", row -> {
            String link = String.valueOf(this.paths.admin.editUser.toSlashedString()) + "?username=" + row.user.getUsername();
            return this.digestService.makeATagLink("Edit User Page", link);
        })).build(rows);
    }

    private static class PermissionRequestDto {
        public final SessionBasedUser user;
        private final Instant instantRequested;

        public PermissionRequestDto(SessionBasedUser user, Instant instantRequested) {
            this.user = user;
            this.instantRequested = instantRequested;
        }

        public String getInstantRequested(ZoneId zoneId) {
            return ZonedDateFormatterTool.formatInstantWithZone((Instant)this.instantRequested, (ZoneId)zoneId);
        }
    }
}

