/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.config;

import io.datarouter.auth.config.DatarouterAuthSettingRoot;
import io.datarouter.auth.job.AccountPermissionCacheRefreshJob;
import io.datarouter.auth.job.AuthConfigurationScanJob;
import io.datarouter.auth.job.DatarouterAccountCredentialCleanupJob;
import io.datarouter.auth.job.DatarouterAccountLastUsedFlushJob;
import io.datarouter.auth.job.DatarouterPermissionRequestVacuumJob;
import io.datarouter.auth.job.DatarouterSessionVacuumJob;
import io.datarouter.auth.job.SamlAuthnRequestRedirectUrlVacuumJob;
import io.datarouter.job.BaseTriggerGroup;
import io.datarouter.storage.tag.Tag;
import io.datarouter.util.duration.DatarouterDuration;
import io.datarouter.util.time.ZoneIds;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DatarouterAuthTriggerGroup
extends BaseTriggerGroup {
    @Inject
    public DatarouterAuthTriggerGroup(DatarouterAuthSettingRoot settings) {
        super("DatarouterAuth", Tag.DATAROUTER, ZoneIds.AMERICA_NEW_YORK);
        this.registerLocked("50 20 * * * ?", (Supplier)settings.runSamlAuthnRequestRedirectUrlVacuumJob, SamlAuthnRequestRedirectUrlVacuumJob.class, true);
        this.registerLocked("45 47 * * * ?", () -> true, DatarouterAccountCredentialCleanupJob.class, true);
        this.registerParallel("0/5 * * * * ?", (Supplier)settings.runDatarouterAccountLastUsedFlushJob, DatarouterAccountLastUsedFlushJob.class);
        this.registerLocked("29 1/2 * * * ?", (Supplier)settings.runUserSessionVacuumJob, DatarouterSessionVacuumJob.class, true);
        this.registerLocked("0 0 14 ? * MON,TUE,WED,THU,FRI *", (Supplier)settings.runConfigurationScanReportEmailJob, AuthConfigurationScanJob.class, true);
        this.registerLocked("0 0 15 ? * * *", (Supplier)settings.runPermissionRequestVacuumJob, DatarouterPermissionRequestVacuumJob.class, true);
        long refreshFrequencySeconds = ((DatarouterDuration)settings.accountRefreshFrequencyDuration.get()).toSecond();
        this.registerParallel("1/" + refreshFrequencySeconds + " * * * * ?", () -> true, AccountPermissionCacheRefreshJob.class);
    }
}

