/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.web;

import io.datarouter.auth.storage.account.DatarouterAccount;
import io.datarouter.auth.storage.account.DatarouterAccountCredential;
import io.datarouter.auth.storage.account.DatarouterAccountCredentialDao;
import io.datarouter.auth.storage.account.DatarouterAccountDao;
import io.datarouter.auth.storage.account.DatarouterAccountKey;
import io.datarouter.auth.storage.account.DatarouterAccountSecretCredential;
import io.datarouter.auth.storage.account.DatarouterAccountSecretCredentialDao;
import io.datarouter.auth.storage.accountpermission.DatarouterAccountPermission;
import io.datarouter.auth.storage.accountpermission.DatarouterAccountPermissionDao;
import io.datarouter.auth.storage.useraccountmap.DatarouterUserAccountMap;
import io.datarouter.auth.storage.useraccountmap.DatarouterUserAccountMapDao;
import io.datarouter.instrumentation.changelog.ChangelogRecorder;
import io.datarouter.scanner.Scanner;
import io.datarouter.util.string.StringTool;
import io.datarouter.util.timer.PhaseTimer;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.handler.types.Param;
import io.datarouter.web.handler.types.optional.OptionalString;
import io.datarouter.web.html.form.HtmlForm;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4FormHtml;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4PageFactory;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.FormTag;
import java.util.List;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatarouterAccountRenameHandler
extends BaseHandler {
    private static final Logger logger = LoggerFactory.getLogger(DatarouterAccountRenameHandler.class);
    private static final String P_oldAccountName = "oldAccountName";
    private static final String P_newAccountName = "newAccountName";
    private static final String P_submitAction = "submitAction";
    @Inject
    private DatarouterAccountDao accountDao;
    @Inject
    private DatarouterAccountCredentialDao accountCredentialDao;
    @Inject
    private DatarouterAccountSecretCredentialDao secretCredentialDao;
    @Inject
    private DatarouterAccountPermissionDao accountPermissionDao;
    @Inject
    private DatarouterUserAccountMapDao userAccountMapDao;
    @Inject
    private ChangelogRecorder changelogRecorder;
    @Inject
    private Bootstrap4PageFactory pageFactory;

    @BaseHandler.Handler(defaultHandler=true)
    public Mav renameAccounts(@Param(value="oldAccountName") OptionalString oldAccountName, @Param(value="newAccountName") OptionalString newAccountName, @Param(value="submitAction") OptionalString submitAction) {
        String errorNewAccountName = null;
        if (submitAction.isPresent()) {
            try {
                newAccountName.map(StringTool::nullIfEmpty).isPresent();
            }
            catch (Exception e) {
                errorNewAccountName = "AccountName cannot have spaces";
            }
        }
        List possibleOldAccountNames = this.accountDao.scanKeys().map(DatarouterAccountKey::getAccountName).sort().list();
        HtmlForm form = new HtmlForm().withMethod("post");
        form.addSelectField().withDisplay("Old AccountName").withName(P_oldAccountName).withValues(possibleOldAccountNames);
        form.addTextField().withDisplay("New Account name").withError(errorNewAccountName).withName(P_newAccountName).withPlaceholder("abc").withValue((String)newAccountName.orElse(null));
        form.addButton().withDisplay("Rename").withValue("anything");
        if (submitAction.isEmpty() || form.hasErrors()) {
            return this.pageFactory.startBuilder(this.request).withTitle("Dataroutetr Account Rename").withContent((DomContent)Html.makeContent(form)).buildMav();
        }
        if (possibleOldAccountNames.contains(newAccountName.get())) {
            throw new RuntimeException(String.format("accountName=%s already exists for DatarouterAccount", newAccountName));
        }
        if (!possibleOldAccountNames.contains(oldAccountName.get())) {
            throw new RuntimeException(String.format("accountName=%s does not exist for DatarouterAccount", oldAccountName));
        }
        this.rename((String)oldAccountName.get(), (String)newAccountName.get());
        return this.pageFactory.message(this.request, "Account renamed from=" + (String)oldAccountName.get() + " to=" + (String)newAccountName.get());
    }

    private void rename(String oldAccountName, String newAccountName) {
        PhaseTimer timer = new PhaseTimer("accountRename");
        this.assertNewAccountNameIsValid(newAccountName);
        timer.add("assertion");
        this.renameDatarouterAccount(oldAccountName, newAccountName);
        timer.add("datarouterAccount");
        this.renameDatarouterAccountCredential(oldAccountName, newAccountName);
        timer.add("accountCredential");
        this.renameDatarouterAccountSecretCredential(oldAccountName, newAccountName);
        timer.add("secretCredential");
        this.renameDatarouterAccountPermission(oldAccountName, newAccountName);
        timer.add("accountPermission");
        this.renameDatarouterUserAccountMaps(oldAccountName, newAccountName);
        timer.add("userAccountMaps");
        logger.warn("{}", (Object)timer.toString());
    }

    private void renameDatarouterAccount(String oldAccountName, String newAccountName) {
        DatarouterAccount oldAccount = this.accountDao.get(new DatarouterAccountKey(oldAccountName));
        DatarouterAccount newAccount = new DatarouterAccount(newAccountName, oldAccount);
        this.accountDao.put(newAccount);
        this.accountDao.delete((DatarouterAccountKey)oldAccount.getKey());
        this.recordChangelog(oldAccountName, newAccountName, "DatarouterAccount");
    }

    private void renameDatarouterAccountCredential(String oldAccountName, String newAccountName) {
        this.accountCredentialDao.scanByAccountName(oldAccountName).include(credential -> credential.getAccountName().equals(oldAccountName)).forEach(credential -> {
            credential.setAccountName(newAccountName);
            this.accountCredentialDao.put((DatarouterAccountCredential)((Object)credential));
            this.recordChangelog(oldAccountName, newAccountName, "DatarouterAccountCredential");
        });
    }

    private void renameDatarouterAccountSecretCredential(String oldAccountName, String newAccountName) {
        this.secretCredentialDao.scan().include(credential -> credential.getAccountName().equals(oldAccountName)).forEach(credential -> {
            credential.setAccountName(newAccountName);
            this.secretCredentialDao.updateIgnore((DatarouterAccountSecretCredential)((Object)credential));
            this.recordChangelog(oldAccountName, newAccountName, "DatarouterAccountSecretCredential");
        });
    }

    private void renameDatarouterAccountPermission(String oldAccountName, String newAccountName) {
        List oldKeys = this.accountPermissionDao.scanKeys().include(key -> key.getAccountName().equals(oldAccountName)).list();
        if (oldKeys.isEmpty()) {
            return;
        }
        List newKeys = Scanner.of((Iterable)oldKeys).map(key -> new DatarouterAccountPermission(newAccountName, key.getEndpoint())).list();
        this.accountPermissionDao.putMulti(newKeys);
        this.accountPermissionDao.deleteMulti(oldKeys);
        this.recordChangelog(oldAccountName, newAccountName, "DatarouterAccountPermission");
    }

    private void renameDatarouterUserAccountMaps(String oldAccountName, String newAccountName) {
        List oldKeys = this.userAccountMapDao.scanKeys().include(key -> key.getAccountName().equals(oldAccountName)).list();
        List newKeys = Scanner.of((Iterable)oldKeys).map(key -> new DatarouterUserAccountMap(key.getUserId(), newAccountName)).list();
        this.userAccountMapDao.putMulti(newKeys);
        this.userAccountMapDao.deleteMulti(oldKeys);
        this.recordChangelog(oldAccountName, newAccountName, "DatarouterAccountSecretCredential");
    }

    private void assertNewAccountNameIsValid(String newAccountName) {
        if (this.accountDao.exists(new DatarouterAccountKey(newAccountName))) {
            throw new RuntimeException(String.format("accountName=%s already exists for DatarouterAccount", newAccountName));
        }
        if (this.accountCredentialDao.exists(newAccountName)) {
            throw new RuntimeException(String.format("accountName=%s already exists for DatarouterAccountCredential", newAccountName));
        }
        boolean containsSecretCredential = this.secretCredentialDao.scan().anyMatch(credential -> credential.getAccountName().equals(newAccountName));
        if (containsSecretCredential) {
            throw new RuntimeException(String.format("accountName=%s already exists for DatarouterSecretAccountCredential", newAccountName));
        }
        boolean containsPermission = this.accountPermissionDao.scanKeys().anyMatch(key -> key.getAccountName().equals(newAccountName));
        if (containsPermission) {
            throw new RuntimeException(String.format("accountName=%s already exists for DatarouterAccountPermission", newAccountName));
        }
        boolean containsUserAccountMappings = this.userAccountMapDao.scanKeys().anyMatch(key -> key.getAccountName().equals(newAccountName));
        if (containsUserAccountMappings) {
            throw new RuntimeException(String.format("accountName=%s already exists for DatarouterUserAccountMap", newAccountName));
        }
    }

    private void recordChangelog(String oldAccountName, String newAccountName, String tableUpdated) {
        ChangelogRecorder.DatarouterChangelogDto dto = new ChangelogRecorder.DatarouterChangelogDtoBuilder("Datarouter account rename", String.valueOf(oldAccountName) + " -> " + newAccountName, tableUpdated, this.getSessionInfo().findNonEmptyUsername().orElse("")).build();
        this.changelogRecorder.record(dto);
    }

    private static class Html {
        private Html() {
        }

        public static DivTag makeContent(HtmlForm htmlForm) {
            FormTag form = (FormTag)Bootstrap4FormHtml.render((HtmlForm)htmlForm).withClass("card card-body bg-light");
            return (DivTag)TagCreator.div((DomContent[])new DomContent[]{TagCreator.h2((String)"Dataroutetr Account Rename"), form, TagCreator.br()}).withClass("container mt-3");
        }
    }
}

