/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.storage.permissionrequest;

import io.datarouter.auth.storage.permissionrequest.DatarouterPermissionRequestKey;
import io.datarouter.auth.storage.userhistory.DatarouterUserHistory;
import io.datarouter.auth.storage.userhistory.DatarouterUserHistoryKey;
import io.datarouter.enums.StringMappedEnum;
import io.datarouter.model.databean.BaseDatabean;
import io.datarouter.model.field.Field;
import io.datarouter.model.field.codec.FieldCodec;
import io.datarouter.model.field.codec.StringMappedEnumFieldCodec;
import io.datarouter.model.field.imp.DateField;
import io.datarouter.model.field.imp.DateFieldKey;
import io.datarouter.model.field.imp.StringEncodedField;
import io.datarouter.model.field.imp.StringEncodedFieldKey;
import io.datarouter.model.field.imp.StringField;
import io.datarouter.model.field.imp.StringFieldKey;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.BaseDatabeanFielder;
import java.time.Instant;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

public class DatarouterPermissionRequest
extends BaseDatabean<DatarouterPermissionRequestKey, DatarouterPermissionRequest> {
    private String requestText;
    private DatarouterPermissionRequestResolution resolution;
    private Date resolutionTime;
    public static final Comparator<DatarouterPermissionRequest> REVERSE_CHRONOLOGICAL_COMPARATOR = Comparator.comparing(request -> ((DatarouterPermissionRequestKey)request.getKey()).getRequestTime(), Comparator.reverseOrder());

    public DatarouterPermissionRequest() {
        super((PrimaryKey)new DatarouterPermissionRequestKey());
    }

    public DatarouterPermissionRequest(Long userId, Date requestTime, String requestText, DatarouterPermissionRequestResolution resolution, Date resolutionTime) {
        super((PrimaryKey)new DatarouterPermissionRequestKey(userId, requestTime));
        this.requestText = requestText;
        this.resolution = resolution;
        this.resolutionTime = resolutionTime;
    }

    public Optional<DatarouterUserHistoryKey> toUserHistoryKey() {
        return Optional.ofNullable(this.resolutionTime).map(Date::toInstant).map(time -> new DatarouterUserHistoryKey(((DatarouterPermissionRequestKey)this.getKey()).getUserId(), (Instant)time));
    }

    private DatarouterPermissionRequest resolve(DatarouterPermissionRequestResolution resolution, Optional<Instant> resolutionTime) {
        this.setResolution(resolution);
        this.setResolutionTime(resolutionTime.orElse(null));
        return this;
    }

    public DatarouterPermissionRequest changeUser(DatarouterUserHistory change) {
        return this.resolve(DatarouterPermissionRequestResolution.USER_CHANGED, Optional.of(((DatarouterUserHistoryKey)change.getKey()).getTime()));
    }

    public DatarouterPermissionRequest supercede() {
        return this.resolve(DatarouterPermissionRequestResolution.SUPERCEDED, Optional.of(Instant.now()));
    }

    public DatarouterPermissionRequest decline() {
        return this.decline(Instant.now());
    }

    public DatarouterPermissionRequest decline(Instant time) {
        return this.resolve(DatarouterPermissionRequestResolution.DECLINED, Optional.ofNullable(time));
    }

    public Supplier<DatarouterPermissionRequestKey> getKeySupplier() {
        return DatarouterPermissionRequestKey::new;
    }

    public String getRequestText() {
        return this.requestText;
    }

    public void setRequestText(String requestText) {
        this.requestText = requestText;
    }

    public DatarouterPermissionRequestResolution getResolution() {
        return this.resolution;
    }

    public void setResolution(DatarouterPermissionRequestResolution resolution) {
        this.resolution = resolution;
    }

    public Optional<Instant> getResolutionTime() {
        return Optional.ofNullable(this.resolutionTime).map(Date::toInstant);
    }

    public void setResolutionTime(Instant resolutionTime) {
        this.resolutionTime = Date.from(resolutionTime);
    }

    public static class DatarouterPermissionRequestFielder
    extends BaseDatabeanFielder<DatarouterPermissionRequestKey, DatarouterPermissionRequest> {
        public DatarouterPermissionRequestFielder() {
            super(DatarouterPermissionRequestKey::new);
        }

        public List<Field<?>> getNonKeyFields(DatarouterPermissionRequest databean) {
            return List.of(new StringField(FieldKeys.requestText, databean.requestText), new StringEncodedField(FieldKeys.resolution, (Object)databean.resolution), new DateField(FieldKeys.resolutionTime, databean.resolutionTime));
        }
    }

    public static enum DatarouterPermissionRequestResolution {
        SUPERCEDED("superceded"),
        USER_CHANGED("changed"),
        DECLINED("declined");

        public static final StringMappedEnum<DatarouterPermissionRequestResolution> BY_PERSISTENT_STRING;
        public final String persistentString;

        static {
            BY_PERSISTENT_STRING = new StringMappedEnum((Object[])DatarouterPermissionRequestResolution.values(), value -> value.persistentString);
        }

        private DatarouterPermissionRequestResolution(String persistentString) {
            this.persistentString = persistentString;
        }
    }

    public static class FieldKeys {
        public static final StringFieldKey requestText = new StringFieldKey("requestText").withSize(65535);
        public static final StringEncodedFieldKey<DatarouterPermissionRequestResolution> resolution = new StringEncodedFieldKey("resolution", (FieldCodec)new StringMappedEnumFieldCodec(DatarouterPermissionRequestResolution.BY_PERSISTENT_STRING));
        public static final DateFieldKey resolutionTime = new DateFieldKey("resolutionTime");
    }
}

