/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.service;

import io.datarouter.auth.service.DatarouterAccountCredentialService;
import io.datarouter.httpclient.security.DefaultCsrfGenerator;
import io.datarouter.web.security.CsrfValidator;
import io.datarouter.web.security.DefaultCsrfValidator;
import io.datarouter.web.util.http.RequestTool;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatarouterAccountCsrfValidator
implements CsrfValidator {
    private static final Logger logger = LoggerFactory.getLogger(DatarouterAccountCsrfValidator.class);
    private final Long requestTimeoutMs;
    private final String apiKeyFieldName;
    private final DatarouterAccountCredentialService datarouterAccountCredentialService;

    private DatarouterAccountCsrfValidator(Long requestTimeoutMs, String apiKeyFieldName, DatarouterAccountCredentialService datarouterAccountApiKeyService) {
        this.requestTimeoutMs = requestTimeoutMs;
        this.apiKeyFieldName = apiKeyFieldName;
        this.datarouterAccountCredentialService = datarouterAccountApiKeyService;
    }

    public boolean check(HttpServletRequest request) {
        return this.getCsrfValidatorForAccountWithApiKey(request).map(csrfValidator -> csrfValidator.check(request)).orElse(false);
    }

    public Long getRequestTimeMs(HttpServletRequest request) {
        return this.getCsrfValidatorForAccountWithApiKey(request).map(csrfValidator -> csrfValidator.getRequestTimeMs(request)).orElse(null);
    }

    private Optional<DefaultCsrfValidator> getCsrfValidatorForAccountWithApiKey(HttpServletRequest request) {
        String apiKey = RequestTool.getParameterOrHeader((HttpServletRequest)request, (String)this.apiKeyFieldName);
        Optional<String> optionalSecretKey = this.datarouterAccountCredentialService.findSecretKeyForApiKeyAuth(apiKey);
        if (optionalSecretKey.isEmpty()) {
            logger.warn("Missing account for apiKey={}", (Object)apiKey);
        }
        return optionalSecretKey.map(secretKey -> () -> secretKey).map(secretKey -> new DefaultCsrfValidator(new DefaultCsrfGenerator(secretKey), this.requestTimeoutMs));
    }

    @Singleton
    public static class DatarouterAccountCsrfValidatorFactory {
        @Inject
        private DatarouterAccountCredentialService datarouterAccountCredentialService;

        public DatarouterAccountCsrfValidator create(Long requestTimeoutMs) {
            return this.create(requestTimeoutMs, "apiKey");
        }

        public DatarouterAccountCsrfValidator create(Long requestTimeoutMs, String apiKeyFieldName) {
            return new DatarouterAccountCsrfValidator(requestTimeoutMs, apiKeyFieldName, this.datarouterAccountCredentialService);
        }
    }
}

