/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.job;

import io.datarouter.auth.storage.permissionrequest.DatarouterPermissionRequest;
import io.datarouter.auth.storage.permissionrequest.DatarouterPermissionRequestDao;
import io.datarouter.auth.storage.permissionrequest.DatarouterPermissionRequestKey;
import io.datarouter.auth.storage.user.DatarouterUserDao;
import io.datarouter.instrumentation.changelog.ChangelogRecorder;
import io.datarouter.instrumentation.task.TaskTracker;
import io.datarouter.job.BaseJob;
import io.datarouter.model.databean.BaseDatabean;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.config.properties.AdminEmail;
import io.datarouter.web.user.databean.DatarouterUser;
import io.datarouter.web.user.databean.DatarouterUserKey;
import java.time.Instant;
import java.time.Period;
import javax.inject.Inject;

public class DatarouterPermissionRequestVacuumJob
extends BaseJob {
    private static final String CHANGELOG_TYPE = "Permission Request";
    @Inject
    private AdminEmail adminEmail;
    @Inject
    private ChangelogRecorder changelogRecorder;
    @Inject
    private DatarouterUserDao datarouterUserDao;
    @Inject
    private DatarouterPermissionRequestDao permissionRequestDao;

    public void run(TaskTracker tracker) {
        Scanner<DatarouterPermissionRequest> permissionRequests = this.permissionRequestDao.scanOpenPermissionRequests();
        Instant tooOldCutoff = Instant.now().minus(Period.ofDays(30));
        permissionRequests.include(permissionRequest -> ((DatarouterPermissionRequestKey)permissionRequest.getKey()).getRequestTime().isBefore(tooOldCutoff)).map(BaseDatabean::getKey).map(DatarouterPermissionRequestKey::getUserId).forEach(userId -> {
            this.permissionRequestDao.declineAll((Long)userId);
            DatarouterUser user = this.datarouterUserDao.get(new DatarouterUserKey(userId));
            ChangelogRecorder.DatarouterChangelogDto dto = new ChangelogRecorder.DatarouterChangelogDtoBuilder(CHANGELOG_TYPE, user.getUsername(), "Auto Decline", this.adminEmail.get()).withComment(String.valueOf(user.getUsername()) + "'s permission request expired").build();
            this.changelogRecorder.record(dto);
        });
    }
}

