/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.storage.userhistory;

import io.datarouter.auth.storage.permissionrequest.DatarouterPermissionRequest;
import io.datarouter.auth.storage.userhistory.DatarouterUserHistoryKey;
import io.datarouter.enums.MappedEnum;
import io.datarouter.model.databean.BaseDatabean;
import io.datarouter.model.field.Field;
import io.datarouter.model.field.codec.FieldCodec;
import io.datarouter.model.field.codec.StringMappedEnumFieldCodec;
import io.datarouter.model.field.imp.StringEncodedField;
import io.datarouter.model.field.imp.StringEncodedFieldKey;
import io.datarouter.model.field.imp.StringField;
import io.datarouter.model.field.imp.StringFieldKey;
import io.datarouter.model.field.imp.comparable.LongField;
import io.datarouter.model.field.imp.comparable.LongFieldKey;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.BaseDatabeanFielder;
import java.time.Instant;
import java.util.List;
import java.util.function.Supplier;

public class DatarouterUserHistory
extends BaseDatabean<DatarouterUserHistoryKey, DatarouterUserHistory> {
    private Long editor;
    private DatarouterUserChangeType changeType;
    private String changes;

    public DatarouterUserHistory() {
        super((PrimaryKey)new DatarouterUserHistoryKey());
    }

    public DatarouterUserHistory(Long userId, Instant time, Long editor, DatarouterUserChangeType changeType, String changes) {
        super((PrimaryKey)new DatarouterUserHistoryKey(userId, time));
        this.editor = editor;
        this.changeType = changeType;
        this.changes = changes;
    }

    public Supplier<DatarouterUserHistoryKey> getKeySupplier() {
        return DatarouterUserHistoryKey::new;
    }

    public Long getEditor() {
        return this.editor;
    }

    public DatarouterUserChangeType getChangeType() {
        return this.changeType;
    }

    public String getChanges() {
        return this.changes;
    }

    public void setChanges(String changes) {
        this.changes = changes;
    }

    public DatarouterPermissionRequest resolvePermissionRequest(DatarouterPermissionRequest permissionRequest) {
        permissionRequest.changeUser(this);
        return permissionRequest;
    }

    public static enum DatarouterUserChangeType {
        CREATE("create"),
        EDIT("edit"),
        RESET("reset"),
        DEPROVISION("deprovision"),
        RESTORE("restore"),
        INFO("info");

        public static final MappedEnum<DatarouterUserChangeType, String> BY_PERSISTENT_STRING;
        public final String persistentString;

        static {
            BY_PERSISTENT_STRING = new MappedEnum((Object[])DatarouterUserChangeType.values(), value -> value.persistentString);
        }

        private DatarouterUserChangeType(String persistentString) {
            this.persistentString = persistentString;
        }
    }

    public static class DatarouterUserHistoryFielder
    extends BaseDatabeanFielder<DatarouterUserHistoryKey, DatarouterUserHistory> {
        public DatarouterUserHistoryFielder() {
            super(DatarouterUserHistoryKey::new);
        }

        public List<Field<?>> getNonKeyFields(DatarouterUserHistory databean) {
            return List.of(new LongField(FieldKeys.editor, databean.editor), new StringEncodedField(FieldKeys.changeType, (Object)databean.changeType), new StringField(FieldKeys.changes, databean.changes));
        }
    }

    public static class FieldKeys {
        public static final LongFieldKey editor = new LongFieldKey("editor");
        public static final StringEncodedFieldKey<DatarouterUserChangeType> changeType = new StringEncodedFieldKey("changeType", (FieldCodec)new StringMappedEnumFieldCodec(DatarouterUserChangeType.BY_PERSISTENT_STRING));
        public static final StringFieldKey changes = new StringFieldKey("changes").withSize(65535);
    }
}

