/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.web;

import io.datarouter.auth.config.DatarouterAuthFiles;
import io.datarouter.auth.config.DatarouterAuthPaths;
import io.datarouter.auth.service.CopyUserListener;
import io.datarouter.auth.service.DatarouterAccountUserService;
import io.datarouter.auth.service.DatarouterUserCreationService;
import io.datarouter.auth.service.DatarouterUserEditService;
import io.datarouter.auth.service.DatarouterUserHistoryService;
import io.datarouter.auth.service.DatarouterUserService;
import io.datarouter.auth.service.UserInfo;
import io.datarouter.auth.storage.account.DatarouterAccountKey;
import io.datarouter.auth.storage.deprovisioneduser.DeprovisionedUser;
import io.datarouter.auth.storage.deprovisioneduser.DeprovisionedUserDao;
import io.datarouter.auth.storage.deprovisioneduser.DeprovisionedUserKey;
import io.datarouter.auth.storage.permissionrequest.DatarouterPermissionRequest;
import io.datarouter.auth.storage.permissionrequest.DatarouterPermissionRequestDao;
import io.datarouter.auth.storage.permissionrequest.DatarouterPermissionRequestKey;
import io.datarouter.auth.storage.user.DatarouterUserDao;
import io.datarouter.auth.web.CreateUserFormHtml;
import io.datarouter.auth.web.DatarouterPermissionRequestHandler;
import io.datarouter.auth.web.deprovisioning.DeprovisionedUserDto;
import io.datarouter.auth.web.deprovisioning.UserDeprovisioningStatusDto;
import io.datarouter.pathnode.PathNode;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.servertype.ServerTypeDetector;
import io.datarouter.util.string.StringTool;
import io.datarouter.util.time.ZoneIds;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.handler.mav.imp.InContextRedirectMav;
import io.datarouter.web.handler.types.RequestBody;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4PageFactory;
import io.datarouter.web.html.react.bootstrap4.Bootstrap4ReactPageFactory;
import io.datarouter.web.js.DatarouterWebJsTool;
import io.datarouter.web.user.authenticate.config.DatarouterAuthenticationConfig;
import io.datarouter.web.user.databean.DatarouterUser;
import io.datarouter.web.user.detail.DatarouterUserExternalDetailService;
import io.datarouter.web.user.session.CurrentUserSessionInfoService;
import io.datarouter.web.user.session.service.Role;
import io.datarouter.web.user.session.service.RoleManager;
import io.datarouter.web.user.session.service.SessionBasedUser;
import io.datarouter.web.util.http.ResponseTool;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AdminEditUserHandler
extends BaseHandler {
    @Inject
    private DatarouterUserCreationService datarouterUserCreationService;
    @Inject
    private DatarouterUserDao datarouterUserDao;
    @Inject
    private DatarouterUserService datarouterUserService;
    @Inject
    private DatarouterUserEditService datarouterUserEditService;
    @Inject
    private DatarouterUserHistoryService datarouterUserHistoryService;
    @Inject
    private DatarouterAccountUserService datarouterAccountUserService;
    @Inject
    private DatarouterAuthenticationConfig authenticationConfig;
    @Inject
    private RoleManager roleManager;
    @Inject
    private DatarouterAuthPaths paths;
    @Inject
    private DatarouterAuthFiles files;
    @Inject
    private DatarouterPermissionRequestDao datarouterPermissionRequestDao;
    @Inject
    private DeprovisionedUserDao deprovisionedUserDao;
    @Inject
    private ServerTypeDetector serverTypeDetector;
    @Inject
    private Bootstrap4PageFactory pageFactory;
    @Inject
    private Bootstrap4ReactPageFactory reactPageFactory;
    @Inject
    private UserInfo userInfo;
    @Inject
    private CurrentUserSessionInfoService currentUserSessionInfoService;
    @Inject
    private CopyUserListener copyUserListener;
    @Inject
    private DatarouterUserExternalDetailService detailsService;

    @BaseHandler.Handler
    private Mav viewUsers() {
        return this.getReactMav("Datarouter - Users", Optional.empty());
    }

    @BaseHandler.Handler
    private List<DatarouterUserListEntry> listUsers() {
        Set<Long> userIdsWithPermissionRequests = this.datarouterPermissionRequestDao.getUserIdsWithPermissionRequests();
        return this.datarouterUserDao.scan().map(user -> new DatarouterUserListEntry(user.getId().toString(), user.getUsername(), user.getToken(), userIdsWithPermissionRequests.contains(user.getId()), this.detailsService.getUserProfileUrl(user).orElse(""))).list();
    }

    @BaseHandler.Handler
    private Mav createUser() {
        if (this.serverTypeDetector.mightBeProduction()) {
            return this.pageFactory.message(this.request, "This is not supported on production");
        }
        CreateUserFormHtml template = new CreateUserFormHtml(AdminEditUserHandler.roleToStrings(this.roleManager.getConferrableRoles(this.getCurrentUser().getRoles())), this.authenticationConfig, this.paths.admin.createUserSubmit.toSlashedStringAfter((PathNode)this.paths.admin, false));
        return this.pageFactory.startBuilder(this.request).withTitle("Datarouter - Create User").withContent(template.build()).buildMav();
    }

    @BaseHandler.Handler
    private Mav createUserSubmit() {
        if (this.serverTypeDetector.mightBeProduction()) {
            return this.pageFactory.message(this.request, "This is not supported on production");
        }
        DatarouterUser currentUser = this.getCurrentUser();
        if (!this.roleManager.isAdmin(currentUser.getRoles()).booleanValue()) {
            this.handleInvalidRequest();
        }
        String username = this.params.required(this.authenticationConfig.getUsernameParam());
        String password = this.params.required(this.authenticationConfig.getPasswordParam());
        String[] roleStrings = this.params.optionalArray(this.authenticationConfig.getUserRolesParam()).orElse(new String[0]);
        Set<Role> requestedRoles = Arrays.stream(roleStrings).map(arg_0 -> ((RoleManager)this.roleManager).getRoleFromPersistentString(arg_0)).collect(Collectors.toSet());
        boolean enabled = this.params.optionalBoolean(this.authenticationConfig.getEnabledParam(), Boolean.valueOf(true));
        this.datarouterUserCreationService.createManualUser(currentUser, username, password, requestedRoles, enabled, Optional.empty(), Optional.empty());
        return new InContextRedirectMav(this.request, this.paths.admin.viewUsers);
    }

    @BaseHandler.Handler
    private Mav editUser() {
        DatarouterUser currentUser = this.getCurrentUser();
        DatarouterUser userToEdit = this.params.optional("username").map(DatarouterUser.DatarouterUserByUsernameLookup::new).map(this.datarouterUserDao::getByUsername).orElseGet(() -> {
            Optional optionalUserId = this.params.optionalLong("userId");
            if (optionalUserId.isPresent()) {
                return optionalUserId.map(this.datarouterUserService::getUserById).get();
            }
            return currentUser;
        });
        if (!this.checkEditPermission(currentUser, userToEdit, this.datarouterUserService::canEditUser)) {
            return null;
        }
        return this.getReactMav("Datarouter - Edit User " + userToEdit.getUsername(), Optional.of(userToEdit.getUsername()));
    }

    @BaseHandler.Handler
    private EditUserDetailsDto getUserDetails(String username) {
        if (StringTool.isNullOrEmptyOrWhitespace((String)username)) {
            return new EditUserDetailsDto("Invalid username.");
        }
        if (!this.checkEditPermission(this.getCurrentUser(), this.datarouterUserDao.getByUsername(new DatarouterUser.DatarouterUserByUsernameLookup(username)), this.datarouterUserService::canEditUser)) {
            return null;
        }
        return this.getEditUserDetailsDto(username);
    }

    @BaseHandler.Handler
    private EditUserDetailsDto updateUserDetails(@RequestBody EditUserDetailsDto dto) {
        if (dto == null || StringTool.isNullOrEmptyOrWhitespace((String)dto.username) || dto.currentAccounts == null || dto.currentRoles == null) {
            return new EditUserDetailsDto("Invalid request.");
        }
        DatarouterUser currentUser = this.getCurrentUser();
        DatarouterUser userToEdit = this.datarouterUserDao.getByUsername(new DatarouterUser.DatarouterUserByUsernameLookup(dto.username));
        if (!userToEdit.isEnabled().booleanValue()) {
            return new EditUserDetailsDto("This user is not editable.");
        }
        if (!this.checkEditPermission(currentUser, userToEdit, this.datarouterUserService::canEditUser)) {
            return null;
        }
        Set requestedUserRoles = (Set)Scanner.of(dto.currentRoles.entrySet()).include(Map.Entry::getValue).map(Map.Entry::getKey).map(arg_0 -> ((RoleManager)this.roleManager).getRoleFromPersistentString(arg_0)).collect(HashSet::new);
        Set requestedAccounts = (Set)Scanner.of(dto.currentAccounts.entrySet()).include(Map.Entry::getValue).map(Map.Entry::getKey).map(DatarouterAccountKey::new).collect(HashSet::new);
        this.datarouterUserEditService.editUser(userToEdit, currentUser, requestedUserRoles, null, this.getSigninUrl(), requestedAccounts, Optional.ofNullable(dto.currentZoneId).map(ZoneId::of), Optional.empty());
        return this.getEditUserDetailsDto(dto.username);
    }

    @BaseHandler.Handler
    private EditUserDetailsDto updatePassword(@RequestBody UpdatePasswordRequestDto dto) {
        if (dto == null || StringTool.isNullOrEmptyOrWhitespace((String)dto.username) || StringTool.isNullOrEmptyOrWhitespace((String)dto.newPassword)) {
            return new EditUserDetailsDto("Invalid request.");
        }
        DatarouterUser editor = this.getCurrentUser();
        DatarouterUser userToEdit = this.datarouterUserDao.getByUsername(new DatarouterUser.DatarouterUserByUsernameLookup(dto.username));
        if (!this.checkEditPermission(editor, userToEdit, this.datarouterUserService::canEditUserPassword)) {
            return null;
        }
        if (!this.datarouterUserService.canHavePassword(userToEdit)) {
            return new EditUserDetailsDto("This user is externally authenticated and cannot have a password.");
        }
        this.datarouterUserEditService.changePassword(userToEdit, editor, dto.newPassword, this.getSigninUrl());
        return this.getEditUserDetailsDto(userToEdit.getUsername());
    }

    @BaseHandler.Handler
    private EditUserDetailsDto copyUser(String oldUsername, String newUsername) {
        if (StringTool.isNullOrEmptyOrWhitespace((String)oldUsername) || StringTool.isNullOrEmptyOrWhitespace((String)newUsername)) {
            return new EditUserDetailsDto("Invalid request.");
        }
        DatarouterUser editor = this.getCurrentUser();
        DatarouterUser oldUser = this.datarouterUserDao.getByUsername(new DatarouterUser.DatarouterUserByUsernameLookup(oldUsername));
        if (editor.getUsername().equals(oldUser.getUsername())) {
            return new EditUserDetailsDto("Cannot copy yourself.");
        }
        if (!this.datarouterUserService.canEditUser(editor, oldUser)) {
            return new EditUserDetailsDto("Cannot copy user.");
        }
        Set requestedRoles = oldUser.isEnabled() != false ? new HashSet(oldUser.getRoles()) : this.deprovisionedUserDao.find(new DeprovisionedUserKey(oldUsername)).map(DeprovisionedUser::getRoles).orElseGet(HashSet::new);
        Set requestedAccounts = (Set)Scanner.of(this.datarouterAccountUserService.findAccountNamesForUser((SessionBasedUser)oldUser)).map(DatarouterAccountKey::new).collect(Collectors.toCollection(HashSet::new));
        Optional zoneId = oldUser.getZoneId();
        DatarouterUser newUser = this.datarouterUserDao.getByUsername(new DatarouterUser.DatarouterUserByUsernameLookup(newUsername));
        Optional<String> description = Optional.of("User copied from " + oldUsername + " by " + editor.getUsername());
        if (newUser == null) {
            newUser = this.datarouterUserCreationService.createManualUser(editor, newUsername, null, requestedRoles, true, zoneId, description);
        } else {
            requestedRoles.addAll(newUser.getRoles());
            Scanner.of(this.datarouterAccountUserService.findAccountNamesForUser((SessionBasedUser)newUser)).map(DatarouterAccountKey::new).forEach(requestedAccounts::add);
        }
        String signinUrl = this.getSigninUrl();
        this.datarouterUserEditService.editUser(newUser, editor, requestedRoles, true, signinUrl, requestedAccounts, zoneId, description);
        this.datarouterUserHistoryService.recordMessage(oldUser, editor, "User copied to " + newUsername + " by " + editor.getUsername());
        this.copyUserListener.onCopiedUser(oldUsername, newUsername);
        return this.getEditUserDetailsDto(oldUsername);
    }

    private DatarouterUser getCurrentUser() {
        return this.datarouterUserService.getAndValidateCurrentUser(this.getSessionInfo().getRequiredSession());
    }

    private Mav getReactMav(String title, Optional<String> initialUsername) {
        return this.reactPageFactory.startBuilder(this.request).withTitle(title).withReactScript(this.files.js.viewUsersJsx).withJsRawConstant("PATHS", DatarouterWebJsTool.buildRawJsObject(this.buildPaths(this.request.getContextPath()))).withJsStringConstant("INITIAL_USERNAME", initialUsername.orElse("")).buildMav();
    }

    private static List<String> roleToStrings(Collection<Role> roles) {
        return roles.stream().map(Role::getPersistentString).sorted(String.CASE_INSENSITIVE_ORDER).collect(Collectors.toList());
    }

    private boolean checkEditPermission(DatarouterUser currentUser, DatarouterUser userToEdit, BiFunction<DatarouterUser, DatarouterUser, Boolean> permissionMethod) {
        Objects.requireNonNull(currentUser);
        Objects.requireNonNull(userToEdit);
        if (!permissionMethod.apply(currentUser, userToEdit).booleanValue()) {
            this.handleInvalidRequest();
            return false;
        }
        return true;
    }

    private String getSigninUrl() {
        String requestUrlWithoutContext = StringTool.getStringBeforeLastOccurrence((String)this.request.getRequestURI(), (String)this.request.getRequestURL().toString());
        return String.valueOf(requestUrlWithoutContext) + this.request.getContextPath() + this.paths.signin.toSlashedString();
    }

    private void handleInvalidRequest() {
        ResponseTool.sendError((HttpServletResponse)this.response, (int)403, (String)"invalid request");
    }

    private EditUserDetailsDto getEditUserDetailsDto(String username) {
        SessionBasedUser user = this.userInfo.getUserByUsername(username, false).orElseThrow();
        Set<Role> roles = this.userInfo.getRolesByUsername(username, false);
        List permissionRequests = ((Scanner)this.datarouterPermissionRequestDao.scanPermissionRequestsForUser(user.getId()).listTo(requests -> Scanner.of(this.datarouterUserHistoryService.getResolvedRequestToHistoryChangesMap((List<DatarouterPermissionRequest>)requests).entrySet()))).sort(Comparator.comparing(Map.Entry::getKey, DatarouterPermissionRequest.REVERSE_CHRONOLOGICAL_COMPARATOR)).map(this::buildPermissionRequestDto).list();
        return new EditUserDetailsDto(user.getUsername(), user.getId().toString(), user.getToken(), permissionRequests, this.deprovisionedUserDao.find(new DeprovisionedUserKey(username)).map(DeprovisionedUser::toDto).orElseGet(() -> AdminEditUserHandler.buildDeprovisionedUserDto(user, roles)), this.roleManager.getConferrableRoles((Collection)this.getSessionInfo().getRoles()), roles, this.datarouterAccountUserService.getAllAccountNamesWithUserMappingsEnabled(), this.datarouterAccountUserService.findAccountNamesForUser(user), true, "", user.getZoneId().map(ZoneId::getId).orElse(ZoneId.systemDefault().getId()));
    }

    private DatarouterPermissionRequestHandler.PermissionRequestDto buildPermissionRequestDto(Map.Entry<DatarouterPermissionRequest, Optional<String>> entry) {
        ZoneId zoneId = this.currentUserSessionInfoService.getZoneId((ServletRequest)this.getRequest());
        DatarouterPermissionRequest request = entry.getKey();
        return new DatarouterPermissionRequestHandler.PermissionRequestDto(((DatarouterPermissionRequestKey)request.getKey()).getRequestTime(), request.getRequestText(), request.getResolutionTime(), entry.getValue().orElse(null), zoneId);
    }

    private static DeprovisionedUserDto buildDeprovisionedUserDto(SessionBasedUser user, Set<Role> roles) {
        UserDeprovisioningStatusDto status = user.isEnabled() != false ? UserDeprovisioningStatusDto.PROVISIONED : UserDeprovisioningStatusDto.NO_RECORD;
        return new DeprovisionedUserDto(user.getUsername(), Scanner.of(roles).map(Role::getPersistentString).list(), status);
    }

    private Map<String, String> buildPaths(String contextPath) {
        HashMap<String, String> allPaths = new HashMap<String, String>();
        allPaths.putAll(Map.of("editUser", AdminEditUserHandler.getPath(contextPath, this.paths.admin.editUser), "getUserDetails", AdminEditUserHandler.getPath(contextPath, this.paths.admin.getUserDetails), "listUsers", AdminEditUserHandler.getPath(contextPath, this.paths.admin.listUsers), "viewUsers", AdminEditUserHandler.getPath(contextPath, this.paths.admin.viewUsers), "updatePassword", AdminEditUserHandler.getPath(contextPath, this.paths.admin.updatePassword), "updateUserDetails", AdminEditUserHandler.getPath(contextPath, this.paths.admin.updateUserDetails), "permissionRequest", AdminEditUserHandler.getPath(contextPath, (PathNode)this.paths.permissionRequest), "declinePermissionRequests", AdminEditUserHandler.getPath(contextPath, this.paths.permissionRequest.declinePermissionRequests), "deprovisionUsers", AdminEditUserHandler.getPath(contextPath, this.paths.userDeprovisioning.deprovisionUsers), "restoreUsers", AdminEditUserHandler.getPath(contextPath, this.paths.userDeprovisioning.restoreUsers)));
        allPaths.put("copyUser", AdminEditUserHandler.getPath(contextPath, this.paths.admin.copyUser));
        return allPaths;
    }

    private static String getPath(String contextPath, PathNode pathNode) {
        return String.valueOf(contextPath) + pathNode.toSlashedString();
    }

    public static class DatarouterUserListEntry {
        public final String id;
        public final String username;
        public final String token;
        public final boolean hasPermissionRequest;
        public final String profileLink;
        public final String profileClass;

        public DatarouterUserListEntry(String id, String username, String token, boolean hasPermissionRequest, String profileLink) {
            this.id = id;
            this.username = username;
            this.token = token;
            this.hasPermissionRequest = hasPermissionRequest;
            this.profileLink = profileLink;
            this.profileClass = profileLink.isEmpty() ? "hidden" : "";
        }
    }

    public static class EditUserDetailsDto {
        public final String username;
        public final String id;
        public final String token;
        public final List<DatarouterPermissionRequestHandler.PermissionRequestDto> requests;
        public final DeprovisionedUserDto deprovisionedUserDto;
        public final List<String> availableRoles;
        public final Map<String, Boolean> currentRoles;
        public final List<String> availableAccounts;
        public final Map<String, Boolean> currentAccounts;
        public final List<String> availableZoneIds;
        public final String currentZoneId;
        public final boolean success;
        public final String message;

        public EditUserDetailsDto(String username, String id, String token, List<DatarouterPermissionRequestHandler.PermissionRequestDto> requests, DeprovisionedUserDto deprovisionedUserDto, Collection<Role> availableRoles, Collection<Role> currentRoles, Collection<String> availableAccounts, Collection<String> currentAccounts, boolean success, String message, String currentZoneId) {
            this.username = username;
            this.id = id;
            this.token = token;
            this.requests = requests;
            this.deprovisionedUserDto = deprovisionedUserDto;
            this.availableRoles = Scanner.of(availableRoles).map(Role::getPersistentString).sort(StringTool.COLLATOR_COMPARATOR).deduplicateConsecutive().list();
            Set currentRolesSet = (Set)Scanner.of(currentRoles).map(Role::getPersistentString).collect(HashSet::new);
            this.currentRoles = Scanner.of(availableRoles).map(Role::getPersistentString).toMap(Function.identity(), currentRolesSet::contains);
            this.availableAccounts = Scanner.of(availableAccounts).sort(StringTool.COLLATOR_COMPARATOR).deduplicateConsecutive().list();
            HashSet<String> currentAccountsSet = new HashSet<String>(currentAccounts);
            this.currentAccounts = Scanner.of(availableAccounts).toMap(Function.identity(), currentAccountsSet::contains);
            this.success = success;
            this.message = message;
            this.availableZoneIds = Scanner.of((Iterable)ZoneIds.ZONE_IDS).map(ZoneId::getId).sort().list();
            this.currentZoneId = currentZoneId;
        }

        public EditUserDetailsDto(String errorMessage) {
            this.username = null;
            this.id = null;
            this.token = null;
            this.requests = null;
            this.deprovisionedUserDto = null;
            this.availableRoles = null;
            this.currentRoles = null;
            this.availableAccounts = null;
            this.currentAccounts = null;
            this.success = false;
            this.message = errorMessage;
            this.availableZoneIds = null;
            this.currentZoneId = null;
        }
    }

    public static class UpdatePasswordRequestDto {
        public final String username;
        public final String newPassword;

        public UpdatePasswordRequestDto(String username, String newPassword) {
            this.username = username;
            this.newPassword = newPassword;
        }
    }
}

