/*
 * Decompiled with CFR 0.152.
 */
package io.datakernel.launchers.http;

import io.datakernel.bytebuf.ByteBuf;
import io.datakernel.bytebuf.ByteBufStrings;
import io.datakernel.config.Config;
import io.datakernel.config.ConfigConverter;
import io.datakernel.config.ConfigConverters;
import io.datakernel.config.ConfigModule;
import io.datakernel.di.annotation.Inject;
import io.datakernel.di.annotation.Optional;
import io.datakernel.di.annotation.Provides;
import io.datakernel.di.core.Key;
import io.datakernel.di.module.AbstractModule;
import io.datakernel.di.module.Module;
import io.datakernel.di.module.Modules;
import io.datakernel.eventloop.Eventloop;
import io.datakernel.eventloop.EventloopInspector;
import io.datakernel.eventloop.ThrottlingController;
import io.datakernel.http.AsyncHttpServer;
import io.datakernel.http.AsyncServlet;
import io.datakernel.http.HttpResponse;
import io.datakernel.jmx.JmxModule;
import io.datakernel.jmx.JmxModuleInitializers;
import io.datakernel.launcher.Launcher;
import io.datakernel.launcher.OnStart;
import io.datakernel.launchers.initializers.Initializers;
import io.datakernel.net.PrimaryServer;
import io.datakernel.service.ServiceGraphModule;
import io.datakernel.worker.Worker;
import io.datakernel.worker.WorkerId;
import io.datakernel.worker.WorkerPool;
import io.datakernel.worker.WorkerPoolModule;
import io.datakernel.worker.WorkerPools;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class MultithreadedHttpServerLauncher
extends Launcher {
    public static final int PORT = 8080;
    public static final int WORKERS = 4;
    public static final String PROPERTIES_FILE = "http-server.properties";
    public static final String BUSINESS_MODULE_PROP = "businessLogicModule";
    @Inject
    PrimaryServer primaryServer;

    @Provides
    Eventloop primaryEventloop(Config config) {
        return (Eventloop)Eventloop.create().initialize(Initializers.ofEventloop((Config)config.getChild("eventloop.primary")));
    }

    @Provides
    @Worker
    Eventloop workerEventloop(Config config, @Optional ThrottlingController throttlingController) {
        return (Eventloop)((Eventloop)Eventloop.create().initialize(Initializers.ofEventloop((Config)config.getChild("eventloop.worker")))).initialize(eventloop -> eventloop.withInspector((EventloopInspector)throttlingController));
    }

    @Provides
    WorkerPool workerPool(WorkerPools workerPools, Config config) {
        return workerPools.createPool(((Integer)config.get(ConfigConverters.ofInteger(), "workers", (Object)4)).intValue());
    }

    @Provides
    PrimaryServer primaryServer(Eventloop primaryEventloop, WorkerPool.Instances<AsyncHttpServer> workerServers, Config config) {
        return (PrimaryServer)PrimaryServer.create((Eventloop)primaryEventloop, (List)workerServers.getList()).initialize(Initializers.ofPrimaryServer((Config)config.getChild("http")));
    }

    @Provides
    @Worker
    AsyncHttpServer workerServer(Eventloop eventloop, AsyncServlet servlet, Config config) {
        return (AsyncHttpServer)AsyncHttpServer.create((Eventloop)eventloop, (AsyncServlet)servlet).initialize(Initializers.ofHttpWorker((Config)config.getChild("http")));
    }

    @Provides
    Config config() {
        return Config.create().with("http.listenAddresses", Config.ofValue((ConfigConverter)ConfigConverters.ofInetSocketAddress(), (Object)new InetSocketAddress(8080))).with("workers", "4").overrideWith(Config.ofClassPathProperties((String)PROPERTIES_FILE, (boolean)true)).overrideWith(Config.ofProperties((Properties)System.getProperties()).getChild("config"));
    }

    protected final Module getModule() {
        return Modules.combine((Module[])new Module[]{ServiceGraphModule.create(), WorkerPoolModule.create(), (Module)JmxModule.create().initialize(JmxModuleInitializers.ofGlobalEventloopStats()), ConfigModule.create().printEffectiveConfig().rebindImport((Key)new Key<CompletionStage<Void>>(){}, (Key)new Key<CompletionStage<Void>>(OnStart.class){}), this.getBusinessLogicModule()});
    }

    protected Module getBusinessLogicModule() {
        return Module.empty();
    }

    protected void run() throws Exception {
        this.logger.info("HTTP Server is listening on " + Stream.concat(this.primaryServer.getListenAddresses().stream().map(address -> "http://" + ("0.0.0.0".equals(address.getHostName()) ? "localhost" : address.getHostName()) + (address.getPort() != 80 ? ":" + address.getPort() : "") + "/"), this.primaryServer.getSslListenAddresses().stream().map(address -> "https://" + ("0.0.0.0".equals(address.getHostName()) ? "localhost" : address.getHostName()) + (address.getPort() != 80 ? ":" + address.getPort() : "") + "/")).collect(Collectors.joining(" ")));
        this.awaitShutdown();
    }

    public static void main(String[] args) throws Exception {
        String businessLogicModuleName = System.getProperty(BUSINESS_MODULE_PROP);
        AbstractModule businessLogicModule = businessLogicModuleName != null ? (Module)Class.forName(businessLogicModuleName).newInstance() : new AbstractModule(){

            @Provides
            @Worker
            AsyncServlet servlet(@WorkerId int workerId) {
                return request -> HttpResponse.ok200().withBody(ByteBuf.wrapForReading((byte[])ByteBufStrings.encodeAscii((String)("Hello, world! #" + workerId))));
            }
        };
        MultithreadedHttpServerLauncher launcher = new MultithreadedHttpServerLauncher((Module)businessLogicModule){
            final /* synthetic */ Module val$businessLogicModule;
            {
                this.val$businessLogicModule = module;
            }

            @Override
            protected Module getBusinessLogicModule() {
                return this.val$businessLogicModule;
            }
        };
        launcher.launch(args);
    }
}

